/*
 * Decompiled with CFR 0.152.
 */
package reascer.efdg.gameasset;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import reascer.efdg.animation.BasicMultipleAttackAnimation;
import reascer.efdg.animation.SpecialAttackAnimation;
import reascer.efdg.gameasset.EFColliders;
import reascer.efdg.skill.EarthquakeSkill;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.property.AnimationEvent;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.MovementAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.forgeevent.AnimationRegistryEvent;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.LevelUtil;
import yesman.epicfight.api.utils.TimePairList;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.ValueModifier;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.model.armature.HumanoidArmature;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.damagesource.StunType;

@Mod.EventBusSubscriber(modid="efdg", bus=Mod.EventBusSubscriber.Bus.MOD)
public class EFAnimations {
    public static StaticAnimation GREATSWORD_TWOHAND_AUTO_1;
    public static StaticAnimation GREATSWORD_TWOHAND_AUTO_2;
    public static StaticAnimation GREATSWORD_TWOHAND_AUTO_3;
    public static StaticAnimation GREATSWORD_DUAL_AUTO_1;
    public static StaticAnimation GREATSWORD_DUAL_AUTO_2;
    public static StaticAnimation GREATSWORD_DUAL_AUTO_3;
    public static StaticAnimation GREATSWORD_DUAL_AUTO_4;
    public static StaticAnimation GREATSWORD_DUAL_DASH;
    public static StaticAnimation GREATSWORD_DUAL_AIRSLASH;
    public static StaticAnimation GREATSWORD_DUAL_EARTHQUAKE;
    public static StaticAnimation GREATSWORD_DUAL_IDLE;
    public static StaticAnimation GREATSWORD_DUAL_WALK;
    public static StaticAnimation GREATSWORD_DUAL_RUN;

    @SubscribeEvent
    public static void registerAnimations(AnimationRegistryEvent event) {
        event.getRegistryMap().put("efdg", EFAnimations::build);
    }

    private static void build() {
        HumanoidArmature biped = Armatures.BIPED;
        GREATSWORD_DUAL_AUTO_1 = new BasicMultipleAttackAnimation(0.25f, "biped/combat/greatsword_dual_auto_1", (Armature)biped, new AttackAnimation.Phase(0.0f, 0.2f, 0.4f, 0.45f, 0.45f, InteractionHand.OFF_HAND, biped.toolL, null), new AttackAnimation.Phase(0.45f, 0.5f, 0.7f, 0.8f, Float.MAX_VALUE, biped.toolR, null)).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, ValueModifier.multiplier((float)0.7f)).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)0.7f), 1).addProperty(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, (Object)Float.valueOf(1.05f));
        GREATSWORD_DUAL_AUTO_2 = new BasicMultipleAttackAnimation(0.15f, 0.35f, 0.85f, 0.85f, EFColliders.GREATSWORD_DOUBLESWING, biped.toolR, "biped/combat/greatsword_dual_auto_2", (Armature)biped).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, ValueModifier.multiplier((float)1.5f)).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.multiplier((float)0.8f)).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.FALL).addProperty(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, (Object)Float.valueOf(1.05f)).addEvents(new AnimationEvent.TimeStampedEvent[]{AnimationEvent.TimeStampedEvent.create((float)0.85f, (AnimationEvent.AnimationEventConsumer)ReuseableEvents.GROUNDSLAM_SMALL, (AnimationEvent.Side)AnimationEvent.Side.CLIENT)});
        GREATSWORD_DUAL_AUTO_3 = new BasicMultipleAttackAnimation(0.15f, "biped/combat/greatsword_dual_auto_3", (Armature)biped, new AttackAnimation.Phase(0.0f, 0.2f, 0.4f, 0.45f, 0.45f, biped.toolR, null), new AttackAnimation.Phase(0.45f, 0.55f, 0.7f, 0.7f, Float.MAX_VALUE, InteractionHand.OFF_HAND, biped.toolL, null)).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, ValueModifier.multiplier((float)0.6f)).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)1.0f), 1).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.multiplier((float)1.5f), 1).addProperty(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, (Object)Float.valueOf(1.05f)).addEvents(new AnimationEvent.TimeStampedEvent[]{AnimationEvent.TimeStampedEvent.create((float)0.45f, (AnimationEvent.AnimationEventConsumer)ReuseableEvents.GROUNDSLAM_SMALL, (AnimationEvent.Side)AnimationEvent.Side.CLIENT)});
        GREATSWORD_DUAL_AUTO_4 = new BasicMultipleAttackAnimation(0.1f, 0.8f, 1.0f, 1.25f, InteractionHand.OFF_HAND, EFColliders.GREATSWORD_DUAL, biped.rootJoint, "biped/combat/greatsword_dual_auto_4", (Armature)biped).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, ValueModifier.multiplier((float)1.8f)).addProperty(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, (Object)Float.valueOf(0.75f));
        GREATSWORD_DUAL_DASH = new BasicMultipleAttackAnimation(0.05f, 0.1f, 0.4f, 0.4f, EFColliders.SHOULDER_BUMP, biped.rootJoint, "biped/combat/greatsword_dual_dash", (Armature)biped).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, ValueModifier.multiplier((float)0.2f)).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.multiplier((float)1.5f)).addProperty(AnimationProperty.AttackPhaseProperty.PARTICLE, (Object)EpicFightParticles.HIT_BLUNT).addProperty(AnimationProperty.AttackPhaseProperty.HIT_SOUND, (Object)EpicFightSounds.BLUNT_HIT).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.HOLD).addProperty(AnimationProperty.AttackAnimationProperty.FIXED_MOVE_DISTANCE, (Object)false).addProperty(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, (Object)Float.valueOf(1.05f));
        GREATSWORD_DUAL_AIRSLASH = new BasicMultipleAttackAnimation(0.05f, 0.25f, 0.4f, 0.45f, InteractionHand.OFF_HAND, EFColliders.AIRSLAM, biped.rootJoint, "biped/combat/greatsword_dual_airslash", (Armature)biped).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, ValueModifier.multiplier((float)1.8f)).addProperty(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, (Object)Float.valueOf(1.05f)).addProperty(AnimationProperty.ActionAnimationProperty.CANCELABLE_MOVE, (Object)false).addProperty(AnimationProperty.ActionAnimationProperty.NO_GRAVITY_TIME, (Object)TimePairList.create((float[])new float[]{0.0f, 0.2f})).addProperty(AnimationProperty.StaticAnimationProperty.PLAY_SPEED_MODIFIER, (self, entitypatch, speed, elapsedTime) -> {
            if (elapsedTime >= 0.2f && elapsedTime < 0.35f) {
                float dpx = (float)((LivingEntity)entitypatch.getOriginal()).m_20185_();
                float dpy = (float)((LivingEntity)entitypatch.getOriginal()).m_20186_();
                float dpz = (float)((LivingEntity)entitypatch.getOriginal()).m_20189_();
                BlockState block = ((LivingEntity)entitypatch.getOriginal()).f_19853_.m_8055_(new BlockPos(new Vec3((double)dpx, (double)dpy, (double)dpz)));
                while ((block.m_60734_() instanceof BushBlock || block.m_60795_()) && !block.m_60713_(Blocks.f_50626_)) {
                    block = ((LivingEntity)entitypatch.getOriginal()).f_19853_.m_8055_(new BlockPos(new Vec3((double)dpx, (double)(dpy -= 1.0f), (double)dpz)));
                }
                float distanceToGround = (float)Math.max(Math.abs(((LivingEntity)entitypatch.getOriginal()).m_20186_() - (double)dpy) - 1.0, 0.0);
                return 1.0f - (1.0f / (-distanceToGround - 1.0f) + 1.0f);
            }
            return 1.0f;
        }).addEvents(new AnimationEvent.TimeStampedEvent[]{AnimationEvent.TimeStampedEvent.create((float)0.4f, (AnimationEvent.AnimationEventConsumer)ReuseableEvents.GROUNDSLAM_SMALL, (AnimationEvent.Side)AnimationEvent.Side.CLIENT)});
        GREATSWORD_DUAL_EARTHQUAKE = new SpecialAttackAnimation(0.15f, "biped/skill/greatsword_dual_earthquake", (Armature)biped, new AttackAnimation.Phase(0.0f, 1.1f, 1.1f, 1.25f, 1.25f, biped.toolR, EFColliders.GREATSWORD_DOUBLESWING), new AttackAnimation.Phase(1.25f, 1.3f, 1.4f, 1.5f, Float.MAX_VALUE, biped.rootJoint, EFColliders.GREATSWORD_DUAL)).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, ValueModifier.multiplier((float)1.2f)).addProperty(AnimationProperty.AttackPhaseProperty.DAMAGE_MODIFIER, (Object)ValueModifier.multiplier((float)2.4f), 1).addProperty(AnimationProperty.AttackPhaseProperty.IMPACT_MODIFIER, (Object)ValueModifier.multiplier((float)2.0f), 1).addProperty(AnimationProperty.AttackPhaseProperty.STUN_TYPE, (Object)StunType.SHORT, 1).addProperty(AnimationProperty.AttackAnimationProperty.BASIS_ATTACK_SPEED, (Object)Float.valueOf(1.05f)).addEvents(new AnimationEvent.TimeStampedEvent[]{AnimationEvent.TimeStampedEvent.create((float)1.25f, (AnimationEvent.AnimationEventConsumer)ReuseableEvents.GROUNDSLAM_SMALL, (AnimationEvent.Side)AnimationEvent.Side.CLIENT), AnimationEvent.TimeStampedEvent.create((float)1.45f, (entitypatch, self, params) -> ((PlayerPatch)entitypatch).getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getDataManager().setDataSync(EarthquakeSkill.SUPERARMOR, (Object)false, (ServerPlayer)entitypatch.getOriginal()), (AnimationEvent.Side)AnimationEvent.Side.SERVER)});
        GREATSWORD_DUAL_IDLE = new StaticAnimation(0.1f, true, "biped/living/greatsword_dual_idle", (Armature)biped);
        GREATSWORD_DUAL_WALK = new MovementAnimation(0.1f, true, "biped/living/greatsword_dual_walk", (Armature)biped);
        GREATSWORD_DUAL_RUN = new MovementAnimation(0.1f, true, "biped/living/greatsword_dual_run", (Armature)biped);
    }

    private static class ReuseableEvents {
        public static final AnimationEvent.AnimationEventConsumer GROUNDSLAM_SMALL = (entitypatch, self, params) -> {
            Vec3 position = ((LivingEntity)entitypatch.getOriginal()).m_20182_();
            OpenMatrix4f modelTransform = entitypatch.getArmature().getBindedTransformFor(entitypatch.getArmature().getPose(1.0f), Armatures.BIPED.toolR).mulFront(OpenMatrix4f.createTranslation((float)((float)position.f_82479_), (float)((float)position.f_82480_), (float)((float)position.f_82481_)).mulBack(OpenMatrix4f.createRotatorDeg((float)180.0f, (Vec3f)Vec3f.Y_AXIS).mulBack(entitypatch.getModelMatrix(1.0f))));
            Vec3 weaponEdge = OpenMatrix4f.transform((OpenMatrix4f)modelTransform, (Vec3)new Vec3f(0.0f, 0.0f, -1.4f).toDoubleVector());
            Level level = ((LivingEntity)entitypatch.getOriginal()).f_19853_;
            Vec3 floorPos = ReuseableEvents.getfloor(entitypatch, self, new Vec3f(0.0f, 0.0f, -1.4f), Armatures.BIPED.toolR);
            BlockState blockState = ((LivingEntity)entitypatch.getOriginal()).f_19853_.m_8055_(new BlockPos(floorPos));
            if (entitypatch instanceof PlayerPatch) {
                ((LivingEntity)entitypatch.getOriginal()).f_19853_.m_6269_((Player)entitypatch.getOriginal(), entitypatch.getOriginal(), blockState.m_60713_(Blocks.f_49990_) ? SoundEvents.f_11917_ : EpicFightSounds.GROUND_SLAM, SoundSource.PLAYERS, 1.5f, 1.5f - (new Random().nextFloat() - 0.5f) * 0.2f);
            }
            weaponEdge = new Vec3(weaponEdge.f_82479_, floorPos.f_82480_, weaponEdge.f_82481_);
            LevelUtil.circleSlamFracture((LivingEntity)((LivingEntity)entitypatch.getOriginal()), (Level)level, (Vec3)weaponEdge, (double)2.0, (boolean)true, (boolean)false);
        };

        private ReuseableEvents() {
        }

        public static Vec3 getfloor(LivingEntityPatch<?> entitypatch, StaticAnimation self, Vec3f WeaponOffset, Joint joint) {
            OpenMatrix4f transformMatrix = entitypatch.getArmature().getBindedTransformFor(entitypatch.getArmature().getPose(1.0f), joint);
            transformMatrix.translate(WeaponOffset);
            OpenMatrix4f CORRECTION = new OpenMatrix4f().rotate(-((float)Math.toRadians(((LivingEntity)entitypatch.getOriginal()).f_19859_ + 180.0f)), new Vec3f(0.0f, 1.0f, 0.0f));
            OpenMatrix4f.mul((OpenMatrix4f)CORRECTION, (OpenMatrix4f)transformMatrix, (OpenMatrix4f)transformMatrix);
            float dpx = transformMatrix.m30 + (float)((LivingEntity)entitypatch.getOriginal()).m_20185_();
            float dpy = transformMatrix.m31 + (float)((LivingEntity)entitypatch.getOriginal()).m_20186_();
            float dpz = transformMatrix.m32 + (float)((LivingEntity)entitypatch.getOriginal()).m_20189_();
            BlockState block = ((LivingEntity)entitypatch.getOriginal()).f_19853_.m_8055_(new BlockPos(new Vec3((double)dpx, (double)dpy, (double)dpz)));
            while ((block.m_60734_() instanceof BushBlock || block.m_60795_()) && !block.m_60713_(Blocks.f_50626_)) {
                block = ((LivingEntity)entitypatch.getOriginal()).f_19853_.m_8055_(new BlockPos(new Vec3((double)dpx, (double)(dpy -= 1.0f), (double)dpz)));
            }
            return new Vec3((double)dpx, (double)dpy, (double)dpz);
        }
    }
}

