/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.villagernames_common_forge.events;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_forge.functions.EntityFunctions;
import com.natamus.villagernames_common_forge.config.ConfigHandler;
import com.natamus.villagernames_common_forge.data.Variables;
import com.natamus.villagernames_common_forge.util.Names;
import com.natamus.villagernames_common_forge.util.Util;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;

public class VillagerEvent {
    public static void onSpawn(Level level, Entity entity) {
        if (level.f_46443_) {
            return;
        }
        if (entity.m_19880_().contains("villagernames.named")) {
            return;
        }
        if (!(entity instanceof Villager)) {
            boolean goname = false;
            if (ConfigHandler.nameModdedVillagers && EntityFunctions.isModdedVillager((Entity)entity)) {
                goname = true;
            }
            if (!goname) {
                return;
            }
        }
        if (entity.m_8077_() && !Util.shouldOverwriteName(entity)) {
            return;
        }
        String name = Names.getRandomName();
        if (!name.equals("")) {
            EntityFunctions.nameEntity((Entity)entity, (String)name);
            entity.m_19880_().add("villagernames.named");
        }
    }

    public static InteractionResult onVillagerInteract(Player player, Level level, InteractionHand hand, Entity entity, EntityHitResult hitResult) {
        TranslatableComponent profession;
        String translatableInput;
        if (!level.f_46443_) {
            return InteractionResult.PASS;
        }
        if (!entity.getClass().equals(Villager.class)) {
            return InteractionResult.PASS;
        }
        if (!entity.m_8077_()) {
            return InteractionResult.PASS;
        }
        if (player.m_6047_()) {
            return InteractionResult.PASS;
        }
        if (!hand.equals((Object)InteractionHand.MAIN_HAND)) {
            return InteractionResult.PASS;
        }
        Villager villager = (Villager)entity;
        VillagerData d = villager.m_7141_();
        String rawProfession = d.m_35571_().toString();
        if (rawProfession.equals("none") || rawProfession.equals("nitwit")) {
            return InteractionResult.PASS;
        }
        if (rawProfession.contains(":")) {
            rawProfession = rawProfession.split(":")[1];
        }
        if (rawProfession.contains("-")) {
            rawProfession = rawProfession.split("-")[0];
        }
        if ((translatableInput = "entity.minecraft.villager." + rawProfession.trim()).equals((profession = new TranslatableComponent(translatableInput)).getString())) {
            profession = new TextComponent(rawProfession.substring(0, 1).toUpperCase() + rawProfession.substring(1));
        }
        Variables.tradedVillagerPair = new Pair((Object)villager.m_7755_(), (Object)profession);
        return InteractionResult.PASS;
    }
}

