/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.levels;

import com.mlib.Random;
import com.mlib.effects.ParticleHandler;
import com.mlib.effects.SoundHandler;
import com.mlib.math.AnyPos;
import com.mlib.math.Range;
import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;

public class LevelHelper {
    public static boolean isEntityIn(Entity entity, ResourceKey<Level> worldRegistryKey) {
        return entity.f_19853_.m_46472_() == worldRegistryKey;
    }

    public static DifficultyInstance getDifficultyAt(Entity entity) {
        return LevelHelper.getDifficultyAt(entity.f_19853_, entity.m_142538_());
    }

    public static DifficultyInstance getDifficultyAt(Level level, BlockPos position) {
        return level.m_6436_(position);
    }

    public static double getRegionalDifficultyAt(Entity entity) {
        return LevelHelper.getRegionalDifficultyAt(entity.f_19853_, entity.m_142538_());
    }

    public static double getRegionalDifficultyAt(Level level, BlockPos position) {
        return LevelHelper.getDifficultyAt(level, position).m_19056_();
    }

    public static double getClampedRegionalDifficultyAt(Entity entity) {
        return LevelHelper.getClampedRegionalDifficultyAt(entity.f_19853_, entity.m_142538_());
    }

    public static double getClampedRegionalDifficultyAt(Level level, BlockPos position) {
        return LevelHelper.getDifficultyAt(level, position).m_19057_();
    }

    public static boolean isEntityOutside(Entity entity) {
        return entity.f_19853_.m_45527_(entity.m_142538_());
    }

    public static boolean isRainingAt(Entity entity) {
        return entity.f_19853_.m_46758_(entity.m_142538_());
    }

    public static boolean isDayAt(Entity entity) {
        return entity.f_19853_.m_46461_();
    }

    public static boolean isNightAt(Entity entity) {
        return entity.f_19853_.m_46462_();
    }

    public static Pair<Vec3, ServerLevel> getSpawnData(ServerPlayer player) {
        float angle;
        Optional spawnPosition;
        BlockPos respawnPosition = player.m_8961_();
        ServerLevel serverLevel = player.f_8924_.m_129880_(player.m_8963_());
        Vec3 exactSpawnPosition = null;
        if (serverLevel == null) {
            return new Pair((Object)Vec3.f_82478_, null);
        }
        if (respawnPosition != null && (spawnPosition = Player.m_36130_((ServerLevel)serverLevel, (BlockPos)respawnPosition, (float)(angle = player.m_8962_()), (boolean)true, (boolean)true)).isPresent()) {
            exactSpawnPosition = (Vec3)spawnPosition.get();
        }
        if (exactSpawnPosition == null) {
            serverLevel = player.f_8924_.m_129880_(Level.f_46428_);
            assert (serverLevel != null);
            exactSpawnPosition = AnyPos.from(serverLevel.m_8900_()).vec3();
        }
        return new Pair(exactSpawnPosition, (Object)serverLevel);
    }

    public static void teleportToSpawnPosition(ServerPlayer player) {
        Pair<Vec3, ServerLevel> spawnData = LevelHelper.getSpawnData(player);
        Vec3 spawnPosition = (Vec3)spawnData.getFirst();
        ServerLevel level = (ServerLevel)spawnData.getSecond();
        player.m_8999_(level, spawnPosition.f_82479_, spawnPosition.f_82480_, spawnPosition.f_82481_, player.m_146908_(), player.m_146909_());
    }

    public static boolean teleportNearby(LivingEntity target, ServerLevel level, double offset) {
        Vec3 position = AnyPos.from(target.m_20182_()).add(Random.nextDouble(-offset, offset), 0.0, Random.nextDouble(-offset, offset)).vec3();
        BlockPos blockPos = LevelHelper.findBlockPosOnGround((Level)level, position, 3).orElse(null);
        if (blockPos != null && target.m_20984_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), true)) {
            SoundHandler.ENDERMAN_TELEPORT.play((Level)level, position);
            ParticleHandler.PORTAL.spawn(level, position, 10);
            return true;
        }
        return false;
    }

    public static void freezeWater(Entity entity, double radius, int minimumIceDuration, int maximumIceDuration) {
        LevelHelper.freezeWater(entity, radius, minimumIceDuration, maximumIceDuration, true);
    }

    public static void freezeWater(Entity entity, double radius, int minimumIceDuration, int maximumIceDuration, boolean requireOnGround) {
        if (requireOnGround && !entity.m_20096_()) {
            return;
        }
        BlockState iceBlockState = Blocks.f_50449_.m_49966_();
        BlockPos entityPosition = entity.m_142538_();
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        Iterable blocksInRange = BlockPos.m_121940_((BlockPos)entityPosition.m_142022_(-radius, -1.0, -radius), (BlockPos)entityPosition.m_142022_(radius, -1.0, radius));
        for (BlockPos blockPos : blocksInRange) {
            if (!blockPos.m_123314_((Vec3i)entityPosition, radius)) continue;
            mutableBlockPos.m_122178_(blockPos.m_123341_(), blockPos.m_123342_() + 1, blockPos.m_123343_());
            BlockState blockState = entity.f_19853_.m_8055_((BlockPos)mutableBlockPos);
            if (!blockState.m_60795_()) continue;
            BlockState blockState2 = entity.f_19853_.m_8055_(blockPos);
            boolean isWater = blockState2.m_60767_() == Material.f_76305_;
            boolean isFull = blockState2.m_60734_() == Blocks.f_49990_ && (Integer)blockState2.m_61143_((Property)LiquidBlock.f_54688_) == 0;
            boolean canSurvive = iceBlockState.m_60710_((LevelReader)entity.f_19853_, blockPos);
            boolean isUnobstructed = entity.f_19853_.m_45752_(iceBlockState, blockPos, CollisionContext.m_82749_());
            if (!isWater || !isFull || !canSurvive || !isUnobstructed || ForgeEventFactory.onBlockPlace((Entity)entity, (BlockSnapshot)BlockSnapshot.create((ResourceKey)entity.f_19853_.m_46472_(), (LevelAccessor)entity.f_19853_, (BlockPos)blockPos), (Direction)Direction.UP)) continue;
            entity.f_19853_.m_46597_(blockPos, iceBlockState);
            entity.f_19853_.m_186460_(blockPos, Blocks.f_50449_, Mth.m_14072_((java.util.Random)Random.getThreadSafe(), (int)minimumIceDuration, (int)maximumIceDuration));
        }
    }

    public static void spawnItemEntityFlyingTowardsDirection(ItemStack itemStack, Level level, Vec3 from, Vec3 to) {
        Vec3 spawnPosition = AnyPos.from(from).add(Random.nextVector(-0.25, 0.25, 0.125, 0.5, -0.25, 0.25)).vec3();
        Vec3 motion = AnyPos.from(to).sub(spawnPosition).mul(0.1).vec3();
        ItemEntity itemEntity = new ItemEntity(level, spawnPosition.f_82479_, spawnPosition.f_82480_, spawnPosition.f_82481_, itemStack);
        itemEntity.m_20256_(AnyPos.from(motion).add(0.0, Math.pow(AnyPos.from(motion).len().doubleValue(), 0.5) * 0.25, 0.0).vec3());
        level.m_7967_((Entity)itemEntity);
    }

    public static void startRaining(Level level, int ticks, boolean withThunder) {
        LevelData levelData = level.m_6106_();
        if (!(levelData instanceof ServerLevelData)) {
            return;
        }
        ServerLevelData data = (ServerLevelData)levelData;
        data.m_5565_(true);
        data.m_6399_(ticks);
        if (withThunder) {
            data.m_5557_(true);
            data.m_6398_(ticks);
        }
    }

    public static void startRaining(Level level, int ticks) {
        LevelHelper.startRaining(level, ticks, false);
    }

    public static void setClearWeather(Level level, int ticks) {
        LevelData levelData = level.m_6106_();
        if (!(levelData instanceof ServerLevelData)) {
            return;
        }
        ServerLevelData data = (ServerLevelData)levelData;
        data.m_5565_(false);
        data.m_6399_(ticks);
        data.m_5557_(false);
        data.m_6398_(ticks);
    }

    public static <Type extends Number> Optional<BlockPos> findBlockPosOnGround(Level level, Vec3 position, Type yOffset) {
        return LevelHelper.findBlockPosOnGround(level, position.f_82479_, new Range<Double>(position.f_82480_ - yOffset.doubleValue(), position.f_82480_ + yOffset.doubleValue()), position.f_82481_);
    }

    public static <Type extends Number> Optional<BlockPos> findBlockPosOnGround(Level level, Type x, Range<Type> y, Type z) {
        BlockPos blockPos = AnyPos.from(x, y.to, z).block();
        do {
            BlockPos blockPosBelow;
            BlockState blockStateBelow;
            if (!(blockStateBelow = level.m_8055_(blockPosBelow = blockPos.m_7495_())).m_60783_((BlockGetter)level, blockPosBelow, Direction.UP)) continue;
            if (!level.m_46859_(blockPos)) {
                BlockState blockState = level.m_8055_(blockPos);
                VoxelShape voxelshape = blockState.m_60812_((BlockGetter)level, blockPos);
                BlockPos blockPosAbove = AnyPos.from(blockPos).add(0, !voxelshape.m_83281_() ? voxelshape.m_83297_(Direction.Axis.Y) : 0.0, 0).block();
                if (!blockState.m_60812_((BlockGetter)level, blockPosAbove).m_83281_()) continue;
                return Optional.of(blockPosAbove);
            }
            return Optional.of(blockPos);
        } while ((blockPos = blockPos.m_7495_()).m_123342_() >= ((Number)y.from).intValue() - 1);
        return Optional.empty();
    }
}

