/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.data;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mlib.data.ISerializable;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;

public class SerializableHelper {
    public static <Type extends ISerializable> Type read(Supplier<Type> supplier, JsonElement element) {
        ISerializable instance = (ISerializable)supplier.get();
        instance.read(element);
        return (Type)instance;
    }

    public static <Type extends ISerializable> Type read(Supplier<Type> supplier, FriendlyByteBuf buffer) {
        ISerializable instance = (ISerializable)supplier.get();
        instance.read(buffer);
        return (Type)instance;
    }

    public static <Type extends ISerializable> Type read(Supplier<Type> supplier, Tag tag) {
        ISerializable instance = (ISerializable)supplier.get();
        instance.read(tag);
        return (Type)instance;
    }

    public static <Type extends ISerializable, TagType extends Tag> TagType write(Supplier<Type> supplier, TagType tag) {
        ISerializable instance = (ISerializable)supplier.get();
        instance.write(tag);
        return tag;
    }

    public static <Type extends ISerializable> void modify(Supplier<Type> supplier, Tag tag, Consumer<Type> consumer) {
        ISerializable instance = (ISerializable)supplier.get();
        instance.read(tag);
        consumer.accept(instance);
        instance.write(tag);
    }

    static JsonElement getReadSubelement(JsonElement element, String key) {
        if (key == null) {
            return element;
        }
        JsonObject jsonObject = element.getAsJsonObject();
        return jsonObject.has(key) ? jsonObject.get(key) : null;
    }

    static Tag getWriteSubtag(Tag tag, String key, Supplier<Tag> newSubtag) {
        if (key == null) {
            return tag;
        }
        Tag subtag = newSubtag.get();
        ((CompoundTag)tag).m_128365_(key, subtag);
        return subtag;
    }

    static Tag getReadSubtag(Tag tag, String key) {
        if (key == null) {
            return tag;
        }
        CompoundTag subtag = (CompoundTag)tag;
        return subtag.m_128441_(key) ? subtag.m_128423_(key) : null;
    }
}

