/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.contexts;

import com.mlib.contexts.OnCheckSpawn;
import com.mlib.contexts.base.Condition;
import com.mlib.contexts.base.Context;
import com.mlib.contexts.base.Contexts;
import com.mlib.contexts.data.IEntityData;
import com.mlib.data.SerializableHelper;
import com.mlib.data.SerializableStructure;
import com.mlib.modhelper.AutoInstance;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class OnSpawned {
    public static final Consumer<Data> CANCEL = data -> data.cancel.run();
    static final List<DataSafe> CLIENT_PENDING_LIST = new ArrayList<DataSafe>();
    static final List<DataSafe> SERVER_PENDING_LIST = new ArrayList<DataSafe>();

    public static Context<Data> listen(Consumer<Data> consumer) {
        return Contexts.get(Data.class).add(consumer);
    }

    public static Context<DataSafe> listenSafe(Consumer<DataSafe> consumer) {
        return Contexts.get(DataSafe.class).add(consumer);
    }

    @SubscribeEvent
    public static void onSpawn(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (!(entity instanceof LivingEntity)) {
            return;
        }
        LivingEntity entity2 = (LivingEntity)entity;
        Contexts.get(Data.class).dispatch(new Data(entity2, event.loadedFromDisk(), () -> event.setCanceled(true)));
        List<DataSafe> list = entity2.f_19853_.f_46443_ ? CLIENT_PENDING_LIST : SERVER_PENDING_LIST;
        list.add(new DataSafe(entity2, event.loadedFromDisk()));
    }

    @SubscribeEvent
    public static void onClientTickEnd(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        OnSpawned.handle(CLIENT_PENDING_LIST);
    }

    @SubscribeEvent
    public static void onServerTickEnd(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        OnSpawned.handle(SERVER_PENDING_LIST);
    }

    public static <DataType extends Data> Condition<DataType> isNotLoadedFromDisk() {
        return new Condition<Data>(data -> !data.loadedFromDisk);
    }

    public static <DataType extends Data> Condition<DataType> is(Class<?> ... classes) {
        return new Condition<Data>(data -> Arrays.stream(classes).anyMatch(clazz -> data.target.getClass().equals(clazz)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handle(List<DataSafe> pendingList) {
        ArrayList<DataSafe> list;
        List<DataSafe> list2 = pendingList;
        synchronized (list2) {
            list = new ArrayList<DataSafe>(pendingList);
            pendingList.clear();
        }
        list.forEach(data -> {
            if (data.target.isAddedToWorld()) {
                Contexts.get(DataSafe.class).dispatch((DataSafe)data);
            }
        });
    }

    public static class Data
    implements IEntityData {
        public final LivingEntity target;
        public final boolean loadedFromDisk;
        public final Runnable cancel;
        @Nullable
        private final MobSpawnType mobSpawnType;

        public Data(LivingEntity target, boolean loadedFromDisk, Runnable cancel) {
            MobSpawnType mobSpawnType;
            this.target = target;
            this.loadedFromDisk = loadedFromDisk;
            this.cancel = cancel;
            if (target instanceof Mob) {
                Mob mob = (Mob)target;
                mobSpawnType = SerializableHelper.read((Supplier<SpawnTypeInfo>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, <init>(), ()Lcom/mlib/contexts/OnSpawned$SpawnTypeInfo;)(), (Tag)mob.getPersistentData()).mobSpawnType;
            } else {
                mobSpawnType = null;
            }
            this.mobSpawnType = mobSpawnType;
        }

        @Override
        public Entity getEntity() {
            return this.target;
        }

        @Nullable
        public final MobSpawnType getSpawnType() {
            return this.mobSpawnType;
        }
    }

    public static class DataSafe
    extends Data {
        public DataSafe(LivingEntity target, boolean loadedFromDisk) {
            super(target, loadedFromDisk, () -> {});
        }
    }

    public static class SpawnTypeInfo
    extends SerializableStructure {
        public MobSpawnType mobSpawnType = null;

        public SpawnTypeInfo() {
            this.defineEnum("MajruszLibraryMobSpawnType", () -> this.mobSpawnType, x -> {
                this.mobSpawnType = x;
            }, MobSpawnType::values);
        }

        public SpawnTypeInfo(MobSpawnType mobSpawnType) {
            this();
            this.mobSpawnType = mobSpawnType;
        }
    }

    @AutoInstance
    public static class SpawnTypeUpdater {
        public SpawnTypeUpdater() {
            OnCheckSpawn.listen(data -> SerializableHelper.write(() -> new SpawnTypeInfo(data.spawnType), data.mob.getPersistentData()));
        }
    }
}

