/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.config;

import com.mlib.config.ValueConfig;
import com.mlib.text.RegexString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class StringListConfig
extends ValueConfig<List<? extends String>> {
    protected final List<RegexString> strings = new ArrayList<RegexString>();

    public StringListConfig(List<? extends String> defaultValue) {
        super(defaultValue);
        ((List)this.defaultValue).forEach(value -> this.strings.add(new RegexString((String)value)));
    }

    public StringListConfig(String ... values) {
        this(Arrays.asList(values));
    }

    @Override
    public void build(ForgeConfigSpec.Builder builder) {
        super.build(builder);
        builder.comment("Supports 'regular expressions' when text starts with %s prefix.".formatted("{regex}"));
        this.config = builder.defineList(this.name, (List)this.defaultValue, list -> true);
    }

    @Override
    public void onReload() {
        super.onReload();
        this.strings.clear();
        ((List)this.getOrDefault()).forEach(value -> this.strings.add(new RegexString((String)value)));
    }

    public boolean contains(String value) {
        return this.strings.stream().anyMatch(subvalue -> subvalue.matches(value));
    }
}

