/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.config;

import com.mlib.config.UserConfig;
import com.mlib.math.Range;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;

@Deprecated(since="5.1.0 use ValueRangeConfig instead")
public abstract class RangeConfig<Type extends Number>
extends UserConfig
implements Supplier<Range<Type>> {
    protected final Range<Type> defaultValue;
    protected final Predicate predicateFrom;
    protected final Predicate predicateTo;
    protected ForgeConfigSpec.ConfigValue<Type> configFrom = null;
    protected ForgeConfigSpec.ConfigValue<Type> configTo = null;

    public RangeConfig(Range<Type> defaultValue, Range<Type> range) {
        this.defaultValue = defaultValue;
        this.predicateFrom = new Predicate(range, this.lessThanMax());
        this.predicateTo = new Predicate(range, this.moreThanMin());
    }

    @Override
    public UserConfig comment(String comment) {
        return super.comment(String.format("%s\n%s (from < to)", comment, this.predicateFrom));
    }

    @Override
    public boolean isBuilt() {
        return this.configFrom != null && this.configTo != null;
    }

    @Override
    public Range<Type> get() {
        assert (this.isBuilt()) : "Config has not been initialized yet!";
        return new Range<Number>((Number)this.configFrom.get(), (Number)this.configTo.get());
    }

    public Range<Type> getOrDefault() {
        return this.isBuilt() ? this.get() : this.defaultValue;
    }

    private java.util.function.Predicate<Number> lessThanMax() {
        return value -> value.doubleValue() <= ((Number)this.configTo.get()).doubleValue();
    }

    private java.util.function.Predicate<Number> moreThanMin() {
        return value -> value.doubleValue() >= ((Number)this.configFrom.get()).doubleValue();
    }

    protected class Predicate
    implements java.util.function.Predicate<Object> {
        final Range<Type> range;
        final java.util.function.Predicate<Number> condition;

        public Predicate(Range<Type> range, java.util.function.Predicate<Number> condition) {
            this.range = range;
            this.condition = condition;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean test(Object value) {
            if (!(value instanceof Number)) return false;
            Number number = (Number)value;
            if (!(((Number)this.range.from).doubleValue() < number.doubleValue())) return false;
            if (!(number.doubleValue() < ((Number)this.range.to).doubleValue())) return false;
            if (!this.condition.test(number)) return false;
            return true;
        }

        public String toString() {
            return String.format("Range: %s ~ %s", this.range.from, this.range.to);
        }
    }
}

