/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.commands;

import com.mlib.commands.CommandBuilder;
import com.mlib.commands.CommandData;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.coordinates.Coordinates;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.RegisterCommandsEvent;

public class Command {
    static final List<Command> COMMANDS = Collections.synchronizedList(new ArrayList());
    final List<CommandBuilder> builders = new ArrayList<CommandBuilder>();

    public static void registerAll(RegisterCommandsEvent event) {
        COMMANDS.forEach(command -> command.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher()));
    }

    public Command() {
        COMMANDS.add(this);
    }

    protected CommandBuilder newBuilder() {
        CommandBuilder builder = new CommandBuilder();
        this.addBuilder(builder);
        return builder;
    }

    protected int getInteger(CommandData data) {
        return this.getInteger(data, "value");
    }

    protected int getInteger(CommandData data, String name) {
        return (Integer)data.context.getArgument(name, Integer.TYPE);
    }

    protected Optional<Integer> getOptionalInteger(CommandData data) {
        try {
            return Optional.of(this.getInteger(data));
        }
        catch (Throwable exception) {
            return Optional.empty();
        }
    }

    protected Optional<Integer> getOptionalInteger(CommandData data, String name) {
        try {
            return Optional.of(this.getInteger(data, name));
        }
        catch (Throwable exception) {
            return Optional.empty();
        }
    }

    protected <EnumType extends Enum<EnumType>> EnumType getEnumeration(CommandData data, Class<EnumType> enumClass) {
        return this.getEnumeration(data, enumClass.getSimpleName().toLowerCase(), enumClass);
    }

    protected <EnumType extends Enum<EnumType>> EnumType getEnumeration(CommandData data, String name, Class<EnumType> enumClass) {
        return (EnumType)((Enum)data.context.getArgument(name, enumClass));
    }

    protected <EnumType extends Enum<EnumType>> Optional<EnumType> getOptionalEnumeration(CommandData data, Class<EnumType> enumClass) {
        try {
            return Optional.of(this.getEnumeration(data, enumClass));
        }
        catch (Throwable exception) {
            return Optional.empty();
        }
    }

    protected <EnumType extends Enum<EnumType>> Optional<EnumType> getOptionalEnumeration(CommandData data, String name, Class<EnumType> enumClass) {
        try {
            return Optional.of(this.getEnumeration(data, name, enumClass));
        }
        catch (Throwable exception) {
            return Optional.empty();
        }
    }

    protected Vec3 getPosition(CommandData data) {
        return this.getPosition(data, "position");
    }

    protected Vec3 getPosition(CommandData data, String name) {
        return ((Coordinates)data.context.getArgument(name, Coordinates.class)).m_6955_((CommandSourceStack)data.context.getSource());
    }

    protected Optional<Vec3> getOptionalPosition(CommandData data) {
        try {
            return Optional.of(this.getPosition(data));
        }
        catch (Throwable exception) {
            return Optional.empty();
        }
    }

    protected Optional<Vec3> getOptionalPosition(CommandData data, String name) {
        try {
            return Optional.of(this.getPosition(data, name));
        }
        catch (Throwable exception) {
            return Optional.empty();
        }
    }

    protected Entity getEntity(CommandData data) {
        return this.getEntity(data, "entity");
    }

    protected Entity getEntity(CommandData data, String name) {
        try {
            return ((EntitySelector)data.context.getArgument(name, EntitySelector.class)).m_121139_((CommandSourceStack)data.context.getSource());
        }
        catch (Throwable exception) {
            return null;
        }
    }

    protected Optional<Entity> getOptionalEntity(CommandData data) {
        try {
            return Optional.of(this.getEntity(data));
        }
        catch (Throwable exception) {
            return Optional.empty();
        }
    }

    protected Optional<Entity> getOptionalEntity(CommandData data, String name) {
        try {
            return Optional.of(this.getEntity(data, name));
        }
        catch (Throwable exception) {
            return Optional.empty();
        }
    }

    protected Entity getOptionalEntityOrPlayer(CommandData data) throws CommandSyntaxException {
        Optional<Entity> entity = this.getOptionalEntity(data);
        if (entity.isPresent()) {
            return entity.get();
        }
        return data.source.m_81374_();
    }

    protected Collection<? extends Entity> getEntities(CommandData data) {
        return this.getEntities(data, "entities");
    }

    protected Collection<? extends Entity> getEntities(CommandData data, String name) {
        try {
            return ((EntitySelector)data.context.getArgument(name, EntitySelector.class)).m_121160_((CommandSourceStack)data.context.getSource());
        }
        catch (Throwable exception) {
            return new ArrayList();
        }
    }

    protected List<Vec3> getAnyPositions(CommandData data) {
        ArrayList<Vec3> positions = new ArrayList<Vec3>();
        try {
            positions.add(this.getPosition(data));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            positions.add(this.getEntity(data).m_20182_());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.getEntities(data).forEach(entity -> positions.add(entity.m_20182_()));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return positions;
    }

    protected void addBuilders(CommandBuilder ... builders) {
        for (CommandBuilder builder : builders) {
            this.addBuilder(builder);
        }
    }

    protected void addBuilder(CommandBuilder builder) {
        this.builders.add(builder);
    }

    private void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        this.builders.forEach(builder -> builder.register(dispatcher));
    }
}

