/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.util;

import io.redspace.ironsspellbooks.item.armor.UpgradeType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.ItemAttributeModifierEvent;

public class UpgradeUtils {
    public static final Map<EquipmentSlot, UUID> UPGRADE_UUIDS_BY_SLOT = Map.of(EquipmentSlot.HEAD, UUID.fromString("f6c19678-1c70-4d41-ad19-cd84d8610242"), EquipmentSlot.CHEST, UUID.fromString("8d02c916-b0eb-4d17-8414-329b4bd38ae7"), EquipmentSlot.LEGS, UUID.fromString("3739c748-98d4-4a2d-9c25-3b4dec74823d"), EquipmentSlot.FEET, UUID.fromString("41cede88-7881-42dd-aac3-d6ab4b56b1f2"), EquipmentSlot.MAINHAND, UUID.fromString("c3865ad7-1f35-46d4-8b4b-a6b934a1a896"), EquipmentSlot.OFFHAND, UUID.fromString("c508430e-7497-42a9-9a9c-1a324dccca54"));
    public static final String Upgrades = "ISBUpgrades";
    public static final String Upgrade_Key = "id";
    public static final String Slot_Key = "slot";
    public static final String Upgrade_Count = "upgrades";

    public static EquipmentSlot getAssignedEquipmentSlot(ItemStack itemStack) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            if (itemStack.m_41638_(slot).isEmpty()) continue;
            return slot;
        }
        return EquipmentSlot.MAINHAND;
    }

    public static double getValueByOperation(Collection<AttributeModifier> modifiers, AttributeModifier.Operation operation) {
        double total = 0.0;
        for (AttributeModifier a : modifiers) {
            if (a.m_22217_() != operation) continue;
            total += a.m_22218_();
        }
        return total;
    }

    public static UUID UUIDForSlot(EquipmentSlot slot) {
        return UPGRADE_UUIDS_BY_SLOT.get(slot);
    }

    public static boolean isUpgraded(ItemStack stack) {
        return stack.m_41782_() && stack.m_41783_().m_128425_(Upgrades, 9);
    }

    public static void appendUpgrade(ItemStack stack, UpgradeType upgradeType, EquipmentSlot slot) {
        ListTag upgrades = stack.m_41784_().m_128437_(Upgrades, 10);
        for (Tag tag : upgrades) {
            CompoundTag compoundTag = (CompoundTag)tag;
            String upgradeName = compoundTag.m_128461_(Upgrade_Key);
            if (!upgradeName.equalsIgnoreCase(upgradeType.key)) continue;
            compoundTag.m_128405_(Upgrade_Count, compoundTag.m_128451_(Upgrade_Count) + 1);
            stack.m_41700_(Upgrades, (Tag)upgrades);
            return;
        }
        CompoundTag upgrade = new CompoundTag();
        upgrade.m_128359_(Upgrade_Key, upgradeType.key);
        upgrade.m_128359_(Slot_Key, slot.m_20751_());
        upgrade.m_128405_(Upgrade_Count, 1);
        upgrades.add((Object)upgrade);
        stack.m_41700_(Upgrades, (Tag)upgrades);
    }

    public static int getUpgradeCount(ItemStack stack) {
        if (!UpgradeUtils.isUpgraded(stack)) {
            return 0;
        }
        ListTag upgrades = stack.m_41784_().m_128437_(Upgrades, 10);
        int count = 0;
        for (Tag tag : upgrades) {
            CompoundTag compoundTag = (CompoundTag)tag;
            count += compoundTag.m_128451_(Upgrade_Count);
        }
        return count;
    }

    public static EquipmentSlot getUpgradedSlot(ItemStack stack) {
        ListTag upgrades = stack.m_41784_().m_128437_(Upgrades, 10);
        return EquipmentSlot.m_20747_((String)((CompoundTag)upgrades.get(0)).m_128461_(Slot_Key));
    }

    public static double collectAndRemovePreexistingAttribute(ItemAttributeModifierEvent event, Attribute key, AttributeModifier.Operation operationToMatch) {
        if (event.getOriginalModifiers().containsKey((Object)key)) {
            for (AttributeModifier modifier : event.getOriginalModifiers().get((Object)key)) {
                if (!modifier.m_22217_().equals((Object)operationToMatch)) continue;
                event.removeModifier(key, modifier);
                return modifier.m_22218_();
            }
        }
        return 0.0;
    }

    public static Map<UpgradeType, Integer> deserializeUpgrade(ItemStack stack) {
        ListTag upgrades = stack.m_41784_().m_128437_(Upgrades, 10);
        HashMap<UpgradeType, Integer> attributes = new HashMap<UpgradeType, Integer>();
        for (Tag tag : upgrades) {
            CompoundTag compoundTag = (CompoundTag)tag;
            String upgradeKey = compoundTag.m_128461_(Upgrade_Key);
            UpgradeType.getUpgrade(upgradeKey).ifPresent(upgrade -> attributes.put((UpgradeType)((Object)upgrade), compoundTag.m_128451_(Upgrade_Count)));
        }
        return attributes;
    }
}

