/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.util;

import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.capabilities.spell.SpellData;
import io.redspace.ironsspellbooks.capabilities.spellbook.SpellBookData;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.item.SpellBook;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.CastSource;
import io.redspace.ironsspellbooks.spells.CastType;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.Component;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class TooltipsUtils {
    public static List<net.minecraft.network.chat.Component> formatActiveSpellTooltip(ItemStack stack, CastSource castSource) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        AbstractSpell spell = stack.m_41720_() instanceof SpellBook ? SpellBookData.getSpellBookData(stack).getActiveSpell() : SpellData.getSpellData(stack).getSpell();
        SpellType spellType = spell.getSpellType();
        MutableComponent title = Component.translatable("tooltip.irons_spellbooks.selected_spell", spellType.getDisplayName(), Component.literal("" + spell.getLevel(null))).m_130948_(spellType.getSchoolType().getDisplayName().m_7383_());
        List<MutableComponent> uniqueInfo = spell.getUniqueInfo((LivingEntity)player);
        MutableComponent manaCost = TooltipsUtils.getManaCostComponent(spell.getCastType(), spell.getManaCost()).m_130940_(ChatFormatting.BLUE);
        MutableComponent cooldownTime = Component.translatable("tooltip.irons_spellbooks.cooldown_length_seconds", Utils.timeFromTicks(MagicManager.getEffectiveSpellCooldown(spellType, (Player)player, castSource), 1)).m_130940_(ChatFormatting.BLUE);
        ArrayList<net.minecraft.network.chat.Component> lines = new ArrayList<net.minecraft.network.chat.Component>();
        lines.add(Component.empty());
        lines.add((net.minecraft.network.chat.Component)title);
        uniqueInfo.forEach(line -> lines.add((net.minecraft.network.chat.Component)Component.literal(" ").m_7220_((net.minecraft.network.chat.Component)line.m_130940_(ChatFormatting.DARK_GREEN))));
        if (spell.getCastType() != CastType.INSTANT) {
            lines.add((net.minecraft.network.chat.Component)Component.literal(" ").m_7220_((net.minecraft.network.chat.Component)TooltipsUtils.getCastTimeComponent(spell.getCastType(), Utils.timeFromTicks(spell.getEffectiveCastTime((LivingEntity)player), 1)).m_130940_(ChatFormatting.BLUE)));
        }
        if (castSource != CastSource.SWORD || ((Boolean)ServerConfigs.SWORDS_CONSUME_MANA.get()).booleanValue()) {
            lines.add((net.minecraft.network.chat.Component)manaCost);
        }
        lines.add((net.minecraft.network.chat.Component)cooldownTime);
        return lines;
    }

    public static List<net.minecraft.network.chat.Component> formatScrollTooltip(ItemStack stack) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        AbstractSpell spell = SpellData.getSpellData(stack).getSpell();
        SpellType spellType = spell.getSpellType();
        if (spellType == SpellType.NONE_SPELL) {
            return List.of();
        }
        MutableComponent title = Component.translatable("tooltip.irons_spellbooks.level", spell.getLevel(null)).m_130946_(" ").m_7220_((net.minecraft.network.chat.Component)Component.translatable("tooltip.irons_spellbooks.rarity", spell.getRarity().getDisplayName().getString())).m_130948_(spell.getRarity().getDisplayName().m_7383_());
        List<MutableComponent> uniqueInfo = spell.getUniqueInfo((LivingEntity)player);
        MutableComponent whenInSpellBook = Component.translatable("tooltip.irons_spellbooks.scroll_tooltip", new Object[0]).m_130940_(ChatFormatting.GRAY);
        MutableComponent manaCost = TooltipsUtils.getManaCostComponent(spell.getCastType(), spell.getManaCost()).m_130940_(ChatFormatting.BLUE);
        MutableComponent cooldownTime = Component.translatable("tooltip.irons_spellbooks.cooldown_length_seconds", Utils.timeFromTicks(MagicManager.getEffectiveSpellCooldown(spellType, (Player)player, CastSource.SCROLL), 1)).m_130940_(ChatFormatting.BLUE);
        ArrayList<net.minecraft.network.chat.Component> lines = new ArrayList<net.minecraft.network.chat.Component>();
        lines.add((net.minecraft.network.chat.Component)Component.literal(" ").m_7220_((net.minecraft.network.chat.Component)title));
        uniqueInfo.forEach(line -> lines.add((net.minecraft.network.chat.Component)Component.literal(" ").m_7220_((net.minecraft.network.chat.Component)line.m_130940_(ChatFormatting.DARK_GREEN))));
        if (spell.getCastType() != CastType.INSTANT) {
            lines.add((net.minecraft.network.chat.Component)Component.literal(" ").m_7220_((net.minecraft.network.chat.Component)TooltipsUtils.getCastTimeComponent(spell.getCastType(), Utils.timeFromTicks(spell.getEffectiveCastTime((LivingEntity)player), 1)).m_130940_(ChatFormatting.BLUE)));
        }
        lines.add(Component.empty());
        lines.add((net.minecraft.network.chat.Component)whenInSpellBook);
        lines.add((net.minecraft.network.chat.Component)manaCost);
        lines.add((net.minecraft.network.chat.Component)cooldownTime);
        lines.add((net.minecraft.network.chat.Component)spell.getSchoolType().getDisplayName().m_6881_());
        return lines;
    }

    public static MutableComponent getCastTimeComponent(CastType type, String castTime) {
        return switch (type) {
            case CastType.CONTINUOUS -> Component.translatable("tooltip.irons_spellbooks.cast_continuous", castTime);
            case CastType.LONG -> Component.translatable("tooltip.irons_spellbooks.cast_long", castTime);
            case CastType.CHARGE -> Component.translatable("tooltip.irons_spellbooks.cast_charge", castTime);
            default -> Component.translatable("ui.irons_spellbooks.cast_instant", new Object[0]);
        };
    }

    public static MutableComponent getManaCostComponent(CastType castType, int manaCost) {
        if (castType == CastType.CONTINUOUS) {
            return Component.translatable("tooltip.irons_spellbooks.mana_cost_per_second", manaCost * 2);
        }
        return Component.translatable("tooltip.irons_spellbooks.mana_cost", manaCost);
    }
}

