/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.util;

import javax.annotation.Nullable;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.ClampedItemPropertyFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CompassItemPropertyFunctionBackport
implements ClampedItemPropertyFunction {
    public static final int DEFAULT_ROTATION = 0;
    private final CompassWobble wobble = new CompassWobble();
    private final CompassWobble wobbleRandom = new CompassWobble();
    public final CompassTarget compassTarget;

    public CompassItemPropertyFunctionBackport(CompassTarget pCompassTarget) {
        this.compassTarget = pCompassTarget;
    }

    public float m_142187_(ItemStack pStack, @Nullable ClientLevel pLevel, @Nullable LivingEntity pEntity, int pSeed) {
        LivingEntity entity;
        Object object = entity = pEntity != null ? pEntity : pStack.m_41609_();
        if (entity == null) {
            return 0.0f;
        }
        return (pLevel = this.tryFetchLevelIfMissing((Entity)entity, pLevel)) == null ? 0.0f : this.getCompassRotation(pStack, pLevel, pSeed, (Entity)entity);
    }

    private float getCompassRotation(ItemStack pStack, ClientLevel pLevel, int pSeed, Entity pEntity) {
        GlobalPos globalpos = this.compassTarget.getPos(pLevel, pStack, pEntity);
        long i = pLevel.m_46467_();
        return !this.isValidCompassTargetPos(pEntity, globalpos) ? this.getRandomlySpinningRotation(pSeed, i) : this.getRotationTowardsCompassTarget(pEntity, i, globalpos.m_122646_());
    }

    private float getRandomlySpinningRotation(int pSeed, long pTicks) {
        if (this.wobbleRandom.shouldUpdate(pTicks)) {
            this.wobbleRandom.update(pTicks, Math.random());
        }
        double d0 = this.wobbleRandom.rotation + (double)((float)this.hash(pSeed) / 2.1474836E9f);
        return Mth.m_14091_((float)((float)d0), (float)1.0f);
    }

    private float getRotationTowardsCompassTarget(Entity pEntity, long pTicks, BlockPos pPos) {
        Player player;
        double d0 = this.getAngleFromEntityToPos(pEntity, pPos);
        double d1 = this.getWrappedVisualRotationY(pEntity);
        if (pEntity instanceof Player && (player = (Player)pEntity).m_7578_()) {
            if (this.wobble.shouldUpdate(pTicks)) {
                this.wobble.update(pTicks, 0.5 - (d1 - 0.25));
            }
            double d3 = d0 + this.wobble.rotation;
            return Mth.m_14091_((float)((float)d3), (float)1.0f);
        }
        double d2 = 0.5 - (d1 - 0.25 - d0);
        return Mth.m_14091_((float)((float)d2), (float)1.0f);
    }

    @Nullable
    private ClientLevel tryFetchLevelIfMissing(Entity pEntity, @Nullable ClientLevel pLevel) {
        return pLevel == null && pEntity.f_19853_ instanceof ClientLevel ? (ClientLevel)pEntity.f_19853_ : pLevel;
    }

    private boolean isValidCompassTargetPos(Entity pEntity, @Nullable GlobalPos pPos) {
        return pPos != null && pPos.m_122640_() == pEntity.f_19853_.m_46472_() && !(pPos.m_122646_().m_203193_((Position)pEntity.m_20182_()) < (double)1.0E-5f);
    }

    private double getAngleFromEntityToPos(Entity pEntity, BlockPos pPos) {
        Vec3 vec3 = Vec3.m_82512_((Vec3i)pPos);
        return Math.atan2(vec3.m_7094_() - pEntity.m_20189_(), vec3.m_7096_() - pEntity.m_20185_()) / 6.2831854820251465;
    }

    private double getWrappedVisualRotationY(Entity p_234940_) {
        return Mth.m_14109_((double)(p_234940_.m_146908_() / 360.0f), (double)1.0);
    }

    private int hash(int pValue) {
        return pValue * 1327217883;
    }

    @OnlyIn(value=Dist.CLIENT)
    static class CompassWobble {
        double rotation;
        private double deltaRotation;
        private long lastUpdateTick;

        CompassWobble() {
        }

        boolean shouldUpdate(long pTicks) {
            return this.lastUpdateTick != pTicks;
        }

        void update(long pTicks, double p_234976_) {
            this.lastUpdateTick = pTicks;
            double d0 = p_234976_ - this.rotation;
            d0 = Mth.m_14109_((double)(d0 + 0.5), (double)1.0) - 0.5;
            this.deltaRotation += d0 * 0.1;
            this.deltaRotation *= 0.8;
            this.rotation = Mth.m_14109_((double)(this.rotation + this.deltaRotation), (double)1.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface CompassTarget {
        @Nullable
        public GlobalPos getPos(ClientLevel var1, ItemStack var2, Entity var3);
    }
}

