/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.void_school;

import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.entity.spells.void_tentacle.VoidTentacle;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.DefaultConfig;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellRarity;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.Component;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class VoidTentaclesSpell
extends AbstractSpell {
    public static DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchool(SchoolType.ENDER).setMaxLevel(3).setCooldownSeconds(30.0).build();

    public VoidTentaclesSpell() {
        this(1);
    }

    @Override
    public List<MutableComponent> getUniqueInfo(LivingEntity caster) {
        return List.of(Component.translatable("ui.irons_spellbooks.damage", Utils.stringTruncation(this.getDamage(caster), 1)), Component.translatable("ui.irons_spellbooks.radius", Utils.stringTruncation((float)this.getRings() * 1.3f, 1)));
    }

    public VoidTentaclesSpell(int level) {
        super(SpellType.VOID_TENTACLES_SPELL);
        this.level = level;
        this.manaCostPerLevel = 50;
        this.baseSpellPower = 6;
        this.spellPowerPerLevel = 2;
        this.castTime = 20;
        this.baseManaCost = 150;
    }

    @Override
    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)SoundRegistry.VOID_TENTACLES_START.get());
    }

    @Override
    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)SoundRegistry.VOID_TENTACLES_FINISH.get());
    }

    @Override
    public void onCast(Level level, LivingEntity entity, PlayerMagicData playerMagicData) {
        Player player;
        int rings = this.getRings();
        int count = 2;
        Vec3 center = Utils.getTargetBlock(level, entity, ClipContext.Fluid.NONE, 48.0).m_82450_();
        level.m_6263_(entity instanceof Player ? (player = (Player)entity) : null, center.f_82479_, center.f_82480_, center.f_82481_, (SoundEvent)SoundRegistry.VOID_TENTACLES_FINISH.get(), SoundSource.AMBIENT, 1.0f, 1.0f);
        for (int r = 0; r < rings; ++r) {
            float tentacles = count + r * 2;
            int i = 0;
            while ((float)i < tentacles) {
                Vec3 random = new Vec3(Utils.getRandomScaled(1.0), Utils.getRandomScaled(1.0), Utils.getRandomScaled(1.0));
                Vec3 spawn = center.m_82549_(new Vec3(0.0, 0.0, 1.3 * (double)(r + 1)).m_82524_(6.281f / tentacles * (float)i)).m_82549_(random);
                if (!level.m_8055_(new BlockPos(spawn = new Vec3(spawn.f_82479_, (double)Utils.findRelativeGroundLevel(level, spawn, 8), spawn.f_82481_)).m_7495_()).m_60795_()) {
                    VoidTentacle tentacle = new VoidTentacle(level, entity, this.getDamage(entity));
                    tentacle.m_20219_(spawn);
                    tentacle.m_146922_(level.m_5822_().nextInt(360));
                    level.m_7967_((Entity)tentacle);
                }
                ++i;
            }
        }
        super.onCast(level, entity, playerMagicData);
    }

    private float getDamage(LivingEntity entity) {
        return this.getSpellPower((Entity)entity);
    }

    private int getRings() {
        return 1 + this.level;
    }
}

