/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.void_school;

import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.entity.spells.black_hole.BlackHole;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.DefaultConfig;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellRarity;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.AnimationHolder;
import io.redspace.ironsspellbooks.util.Component;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import software.bernie.geckolib3.core.builder.ILoopType;

public class BlackHoleSpell
extends AbstractSpell {
    public static DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchool(SchoolType.ENDER).setMaxLevel(6).setCooldownSeconds(120.0).build();
    public static final AnimationHolder CHARGE_ANIMATION = new AnimationHolder("charge_black_hole", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    public static final AnimationHolder FINISH_ANIMATION = new AnimationHolder("long_cast_finish", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);

    public BlackHoleSpell() {
        this(1);
    }

    @Override
    public List<MutableComponent> getUniqueInfo(LivingEntity caster) {
        return List.of(Component.translatable("ui.irons_spellbooks.aoe_damage", Utils.stringTruncation(this.getDamage(caster), 1)), Component.translatable("ui.irons_spellbooks.radius", Utils.stringTruncation(this.getRadius(caster), 1)));
    }

    public BlackHoleSpell(int level) {
        super(SpellType.BLACK_HOLE_SPELL);
        this.level = level;
        this.manaCostPerLevel = 100;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 0;
        this.castTime = 100;
        this.baseManaCost = 300;
    }

    @Override
    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)SoundRegistry.BLACK_HOLE_CHARGE.get());
    }

    @Override
    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)SoundRegistry.BLACK_HOLE_CAST.get());
    }

    @Override
    public void onCast(Level level, LivingEntity entity, PlayerMagicData playerMagicData) {
        float radius = this.getRadius(entity);
        HitResult raycast = Utils.raycastForEntity(level, (Entity)entity, 16.0f + radius * 1.5f, true);
        Vec3 center = raycast.m_82450_();
        if (raycast instanceof BlockHitResult) {
            BlockHitResult blockHitResult = (BlockHitResult)raycast;
            if (blockHitResult.m_82434_().m_122434_().m_122479_()) {
                center = center.m_82492_(0.0, (double)radius, 0.0);
            } else if (blockHitResult.m_82434_() == Direction.DOWN) {
                center = center.m_82492_(0.0, (double)(radius * 2.0f), 0.0);
            }
        }
        level.m_6263_(null, center.f_82479_, center.f_82480_, center.f_82481_, (SoundEvent)SoundRegistry.BLACK_HOLE_CAST.get(), SoundSource.AMBIENT, 4.0f, 1.0f);
        BlackHole blackHole = new BlackHole(level, entity);
        blackHole.setRadius(radius);
        blackHole.setDamage(this.getDamage(entity));
        blackHole.m_20219_(center);
        level.m_7967_((Entity)blackHole);
        super.onCast(level, entity, playerMagicData);
    }

    private float getDamage(LivingEntity entity) {
        return this.getSpellPower((Entity)entity) * 2.0f;
    }

    private float getRadius(LivingEntity entity) {
        return (float)(2 * this.level + 4) * this.getSpellPower((Entity)entity);
    }

    @Override
    public AnimationHolder getCastStartAnimation() {
        return CHARGE_ANIMATION;
    }

    @Override
    public AnimationHolder getCastFinishAnimation() {
        return FINISH_ANIMATION;
    }
}

