/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.poison;

import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.capabilities.magic.CastData;
import io.redspace.ironsspellbooks.capabilities.magic.CastTargetingData;
import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.entity.spells.root.RootEntity;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.DefaultConfig;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellRarity;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.Component;
import io.redspace.ironsspellbooks.util.ModTags;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class RootSpell
extends AbstractSpell {
    public static DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.UNCOMMON).setSchool(SchoolType.POISON).setMaxLevel(10).setCooldownSeconds(35.0).build();

    public RootSpell() {
        this(1);
    }

    @Override
    public List<MutableComponent> getUniqueInfo(LivingEntity caster) {
        return List.of(Component.translatable("ui.irons_spellbooks.effect_length", Utils.timeFromTicks(this.getDuration(caster), 1)));
    }

    public RootSpell(int level) {
        super(SpellType.ROOT_SPELL);
        this.level = level;
        this.manaCostPerLevel = 3;
        this.baseSpellPower = 5;
        this.spellPowerPerLevel = 1;
        this.castTime = 40;
        this.baseManaCost = 45;
    }

    @Override
    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of(SoundEvents.f_11867_);
    }

    @Override
    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.empty();
    }

    @Override
    public boolean checkPreCastConditions(Level level, LivingEntity entity, PlayerMagicData playerMagicData) {
        return Utils.preCastTargetHelper(level, entity, playerMagicData, this.getSpellType(), 32, 0.35f);
    }

    @Override
    public void onCast(Level level, LivingEntity entity, PlayerMagicData playerMagicData) {
        CastData castData = playerMagicData.getAdditionalCastData();
        if (castData instanceof CastTargetingData) {
            CastTargetingData castTargetingData = (CastTargetingData)castData;
            LivingEntity target = castTargetingData.getTarget((ServerLevel)level);
            IronsSpellbooks.LOGGER.debug("RootSpell.onCast.1 targetEntity:{}", (Object)target);
            if (target != null && !target.m_6095_().m_204039_(ModTags.CANT_ROOT)) {
                IronsSpellbooks.LOGGER.debug("RootSpell.onCast.2 targetEntity:{}", (Object)target);
                Vec3 spawn = target.m_20182_();
                RootEntity rootEntity = new RootEntity(level, entity);
                rootEntity.setDuration(this.getDuration(entity));
                rootEntity.setTarget(target);
                rootEntity.m_20219_(spawn);
                level.m_7967_((Entity)rootEntity);
                target.m_8127_();
                target.m_7998_((Entity)rootEntity, true);
            }
        }
        super.onCast(level, entity, playerMagicData);
    }

    @Nullable
    private LivingEntity findTarget(LivingEntity caster) {
        EntityHitResult entityHit;
        Entity entity;
        HitResult target = Utils.raycastForEntity(caster.f_19853_, (Entity)caster, 32.0f, true, 0.35f);
        if (target instanceof EntityHitResult && (entity = (entityHit = (EntityHitResult)target).m_82443_()) instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)entity;
            return livingTarget;
        }
        return null;
    }

    public int getAmplifier(LivingEntity caster) {
        return (int)(this.getSpellPower((Entity)caster) * (float)this.level - 1.0f);
    }

    public int getDuration(LivingEntity caster) {
        return (int)(this.getSpellPower((Entity)caster) * 20.0f);
    }
}

