/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.poison;

import io.redspace.ironsspellbooks.capabilities.magic.CastData;
import io.redspace.ironsspellbooks.capabilities.magic.CastTargetingData;
import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.entity.spells.poison_cloud.PoisonSplash;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.DefaultConfig;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellRarity;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.Component;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class PoisonSplashSpell
extends AbstractSpell {
    public static DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.UNCOMMON).setSchool(SchoolType.POISON).setMaxLevel(10).setCooldownSeconds(20.0).build();

    public PoisonSplashSpell() {
        this(1);
    }

    @Override
    public List<MutableComponent> getUniqueInfo(LivingEntity caster) {
        return List.of(Component.translatable("ui.irons_spellbooks.damage", Utils.stringTruncation(this.getDamage(caster), 1)), Component.translatable("ui.irons_spellbooks.effect_length", Utils.timeFromTicks(this.getDuration(caster), 1)));
    }

    public PoisonSplashSpell(int level) {
        super(SpellType.POISON_SPLASH_SPELL);
        this.level = level;
        this.manaCostPerLevel = 10;
        this.baseSpellPower = 8;
        this.spellPowerPerLevel = 1;
        this.castTime = 15;
        this.baseManaCost = 40;
    }

    @Override
    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)SoundRegistry.POISON_SPLASH_BEGIN.get());
    }

    @Override
    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.empty();
    }

    @Override
    public boolean checkPreCastConditions(Level level, LivingEntity entity, PlayerMagicData playerMagicData) {
        Utils.preCastTargetHelper(level, entity, playerMagicData, this.getSpellType(), 32, 0.35f, false);
        return true;
    }

    @Override
    public void onCast(Level level, LivingEntity entity, PlayerMagicData playerMagicData) {
        Vec3 spawn = null;
        CastData castData = playerMagicData.getAdditionalCastData();
        if (castData instanceof CastTargetingData) {
            CastTargetingData castTargetingData = (CastTargetingData)castData;
            spawn = castTargetingData.getTargetPosition((ServerLevel)level);
        }
        if (spawn == null) {
            HitResult raycast = Utils.raycastForEntity(level, (Entity)entity, 32.0f, true);
            spawn = raycast.m_6662_() == HitResult.Type.ENTITY ? ((EntityHitResult)raycast).m_82443_().m_20182_() : Utils.moveToRelativeGroundLevel(level, raycast.m_82450_().m_82546_(entity.m_20156_().m_82541_()).m_82520_(0.0, 2.0, 0.0), 5);
        }
        PoisonSplash poisonSplash = new PoisonSplash(level);
        poisonSplash.m_5602_((Entity)entity);
        poisonSplash.m_20219_(spawn);
        poisonSplash.setDamage(this.getDamage(entity));
        poisonSplash.setEffectDuration(this.getDuration(entity));
        level.m_7967_((Entity)poisonSplash);
        super.onCast(level, entity, playerMagicData);
    }

    private float getDamage(LivingEntity entity) {
        return this.getSpellPower((Entity)entity);
    }

    private int getDuration(LivingEntity entity) {
        return 100 + this.level * 40;
    }
}

