/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.poison;

import io.redspace.ironsspellbooks.capabilities.magic.CastData;
import io.redspace.ironsspellbooks.capabilities.magic.CastTargetingData;
import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.DefaultConfig;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellRarity;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.Component;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class BlightSpell
extends AbstractSpell {
    public static DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchool(SchoolType.POISON).setMaxLevel(8).setCooldownSeconds(35.0).build();

    public BlightSpell() {
        this(1);
    }

    @Override
    public List<MutableComponent> getUniqueInfo(LivingEntity caster) {
        return List.of(Component.translatable("ui.irons_spellbooks.reduced_healing", Utils.stringTruncation((float)(1 + this.getAmplifier(caster)) * -0.1f * -100.0f, 1)), Component.translatable("ui.irons_spellbooks.reduced_damage", Utils.stringTruncation((float)(1 + this.getAmplifier(caster)) * -0.05f * -100.0f, 1)), Component.translatable("ui.irons_spellbooks.effect_length", Utils.timeFromTicks(this.getDuration(caster), 1)));
    }

    public BlightSpell(int level) {
        super(SpellType.BLIGHT_SPELL);
        this.level = level;
        this.manaCostPerLevel = 5;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 0;
        this.castTime = 50;
        this.baseManaCost = 10;
    }

    @Override
    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)SoundRegistry.BLIGHT_BEGIN.get());
    }

    @Override
    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.empty();
    }

    @Override
    public boolean checkPreCastConditions(Level level, LivingEntity entity, PlayerMagicData playerMagicData) {
        return Utils.preCastTargetHelper(level, entity, playerMagicData, this.getSpellType(), 32, 0.35f);
    }

    @Override
    public void onCast(Level world, LivingEntity entity, PlayerMagicData playerMagicData) {
        CastTargetingData targetData;
        LivingEntity targetEntity;
        CastData castData = playerMagicData.getAdditionalCastData();
        if (castData instanceof CastTargetingData && (targetEntity = (targetData = (CastTargetingData)castData).getTarget((ServerLevel)world)) != null) {
            targetEntity.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.BLIGHT.get(), this.getDuration(entity), this.getAmplifier(entity)));
        }
        super.onCast(world, entity, playerMagicData);
    }

    public int getAmplifier(LivingEntity caster) {
        return (int)(this.getSpellPower((Entity)caster) * (float)this.level - 1.0f);
    }

    public int getDuration(LivingEntity caster) {
        return (int)(this.getSpellPower((Entity)caster) * 20.0f * 30.0f);
    }
}

