/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.poison;

import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.entity.spells.acid_orb.AcidOrb;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.DefaultConfig;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellRarity;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.AnimationHolder;
import io.redspace.ironsspellbooks.util.Component;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import software.bernie.geckolib3.core.builder.ILoopType;

public class AcidOrbSpell
extends AbstractSpell {
    public static DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.COMMON).setSchool(SchoolType.POISON).setMaxLevel(10).setCooldownSeconds(15.0).build();
    public static final AnimationHolder CHARGE_SPIT_ANIMATION = new AnimationHolder("charge_spit", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    public static final AnimationHolder SPIT_FINISH_ANIMATION = new AnimationHolder("charge_spit_finish", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);

    @Override
    public List<MutableComponent> getUniqueInfo(LivingEntity caster) {
        return List.of(Component.translatable("ui.irons_spellbooks.radius", Utils.stringTruncation(this.getRadius(caster), 1)), Component.translatable("ui.irons_spellbooks.rend", Utils.stringTruncation((this.getRendAmplifier(caster) + 1) * 5, 1)), Component.translatable("ui.irons_spellbooks.effect_length", Utils.timeFromTicks(this.getRendDuration(caster), 1)));
    }

    public AcidOrbSpell(int level) {
        super(SpellType.ACID_ORB_SPELL);
        this.level = level;
        this.manaCostPerLevel = 3;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 0;
        this.castTime = 15;
        this.baseManaCost = 30;
    }

    @Override
    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)SoundRegistry.ACID_ORB_CHARGE.get());
    }

    @Override
    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)SoundRegistry.ACID_ORB_CAST.get());
    }

    @Override
    public void onCast(Level level, LivingEntity entity, PlayerMagicData playerMagicData) {
        AcidOrb orb = new AcidOrb(level, entity);
        orb.m_146884_(entity.m_20182_().m_82520_(0.0, (double)entity.m_20192_() - orb.m_142469_().m_82376_() * 0.5, 0.0).m_82549_(entity.m_20156_()));
        orb.shoot(entity.m_20154_());
        orb.m_20256_(orb.m_20184_().m_82520_(0.0, 0.2, 0.0));
        orb.setExplosionRadius(this.getRadius(entity));
        orb.setRendLevel(this.getRendAmplifier(entity));
        orb.setRendDuration(this.getRendDuration(entity));
        level.m_7967_((Entity)orb);
        super.onCast(level, entity, playerMagicData);
    }

    public float getRadius(LivingEntity caster) {
        return this.getSpellPower((Entity)caster) * 3.0f;
    }

    public int getRendAmplifier(LivingEntity caster) {
        return (int)(this.getSpellPower((Entity)caster) * (float)this.level - 1.0f);
    }

    public int getRendDuration(LivingEntity caster) {
        return (int)(this.getSpellPower((Entity)caster) * 20.0f * 15.0f);
    }

    @Override
    public AnimationHolder getCastStartAnimation() {
        return CHARGE_SPIT_ANIMATION;
    }

    @Override
    public AnimationHolder getCastFinishAnimation() {
        return SPIT_FINISH_ANIMATION;
    }
}

