/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.lightning;

import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.DefaultConfig;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellRarity;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.spells.holy.HealSpell;
import io.redspace.ironsspellbooks.util.AnimationHolder;
import io.redspace.ironsspellbooks.util.Component;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class ChargeSpell
extends AbstractSpell {
    public static DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchool(SchoolType.LIGHTNING).setMaxLevel(3).setCooldownSeconds(40.0).build();

    public ChargeSpell() {
        this(1);
    }

    @Override
    public List<MutableComponent> getUniqueInfo(LivingEntity caster) {
        return List.of(Component.translatable("ui.irons_spellbooks.effect_length", Utils.timeFromTicks(this.getSpellPower((Entity)caster) * 20.0f, 1)), Component.translatable("attribute.modifier.plus.1", Utils.stringTruncation(this.getPercentSpeed(), 0), Component.translatable("attribute.name.generic.movement_speed", new Object[0])), Component.translatable("attribute.modifier.plus.1", Utils.stringTruncation(this.getPercentAttackDamage(), 0), Component.translatable("attribute.name.generic.attack_damage", new Object[0])), Component.translatable("attribute.modifier.plus.1", Utils.stringTruncation(this.getPercentSpellPower(), 0), Component.translatable("attribute.irons_spellbooks.spell_power", new Object[0])));
    }

    public ChargeSpell(int level) {
        super(SpellType.CHARGE_SPELL);
        this.level = level;
        this.manaCostPerLevel = 25;
        this.baseSpellPower = 30;
        this.spellPowerPerLevel = 8;
        this.castTime = 0;
        this.baseManaCost = 50;
    }

    @Override
    public Optional<SoundEvent> getCastStartSound() {
        return Optional.empty();
    }

    @Override
    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.empty();
    }

    @Override
    public void onCast(Level level, LivingEntity entity, PlayerMagicData playerMagicData) {
        entity.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.CHARGED.get(), (int)(this.getSpellPower((Entity)entity) * 20.0f), this.level - 1, false, false, true));
        super.onCast(level, entity, playerMagicData);
    }

    private float getPercentAttackDamage() {
        return (float)this.level * 0.1f * 100.0f;
    }

    private float getPercentSpeed() {
        return (float)this.level * 0.2f * 100.0f;
    }

    private float getPercentSpellPower() {
        return (float)this.level * 0.05f * 100.0f;
    }

    @Override
    public AnimationHolder getCastStartAnimation() {
        return HealSpell.SELF_CAST_ANIMATION;
    }
}

