/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.lightning;

import io.redspace.ironsspellbooks.capabilities.magic.CastData;
import io.redspace.ironsspellbooks.capabilities.magic.CastDataSerializable;
import io.redspace.ironsspellbooks.capabilities.magic.ImpulseCastData;
import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.DefaultConfig;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellRarity;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.Component;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class AscensionSpell
extends AbstractSpell {
    public static DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchool(SchoolType.LIGHTNING).setMaxLevel(10).setCooldownSeconds(15.0).build();

    public AscensionSpell() {
        this(1);
    }

    @Override
    public List<MutableComponent> getUniqueInfo(LivingEntity caster) {
        return List.of(Component.translatable("ui.irons_spellbooks.damage", Utils.stringTruncation(this.getSpellPower((Entity)caster), 1)));
    }

    public AscensionSpell(int level) {
        super(SpellType.ASCENSION_SPELL);
        this.level = level;
        this.manaCostPerLevel = 1;
        this.baseSpellPower = 5;
        this.spellPowerPerLevel = 1;
        this.castTime = 0;
        this.baseManaCost = 50;
    }

    @Override
    public Optional<SoundEvent> getCastStartSound() {
        return Optional.empty();
    }

    @Override
    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.empty();
    }

    @Override
    public CastDataSerializable getEmptyCastData() {
        return new ImpulseCastData();
    }

    @Override
    public void onClientCast(Level level, LivingEntity entity, CastData castData) {
        if (castData instanceof ImpulseCastData) {
            ImpulseCastData data = (ImpulseCastData)castData;
            entity.f_19812_ = data.hasImpulse;
            double y = Math.max(entity.m_20184_().f_82480_, (double)data.y);
            entity.m_20334_((double)data.x, y, (double)data.z);
        }
        super.onClientCast(level, entity, castData);
    }

    @Override
    public void onCast(Level level, LivingEntity entity, PlayerMagicData playerMagicData) {
        entity.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.ASCENSION.get(), 80, 0, false, false, true));
        Vec3 vec = entity.m_20182_();
        for (int i = 0; i < 32 && level.m_8055_(new BlockPos(vec).m_7495_()).m_60795_(); ++i) {
            vec = vec.m_82492_(0.0, 1.0, 0.0);
        }
        Vec3 strikePos = vec;
        LightningBolt lightningBolt = (LightningBolt)EntityType.f_20465_.m_20615_(level);
        lightningBolt.m_20874_(true);
        lightningBolt.setDamage(0.0f);
        lightningBolt.m_146884_(strikePos);
        level.m_7967_((Entity)lightningBolt);
        float radius = 5.0f;
        level.m_45933_((Entity)entity, entity.m_142469_().m_82400_((double)radius)).forEach(target -> {
            double distance = target.m_20238_(strikePos);
            if (distance < (double)(radius * radius)) {
                float finalDamage = (float)((double)this.getDamage(entity) * (1.0 - distance / (double)(radius * radius)));
                DamageSources.applyDamage(target, finalDamage, SpellType.ASCENSION_SPELL.getDamageSource((Entity)lightningBolt, (Entity)entity), SchoolType.LIGHTNING);
                if (target instanceof Creeper) {
                    Creeper creeper = (Creeper)target;
                    creeper.m_8038_((ServerLevel)level, lightningBolt);
                }
            }
        });
        Vec3 motion = entity.m_20154_().m_82542_(1.0, 0.0, 1.0).m_82541_().m_82520_(0.0, 5.0, 0.0).m_82490_(0.125);
        playerMagicData.setAdditionalCastData(new ImpulseCastData((float)motion.f_82479_, (float)motion.f_82480_, (float)motion.f_82481_, true));
        entity.m_20256_(entity.m_20184_().m_82549_(motion));
        entity.f_19812_ = true;
        super.onCast(level, entity, playerMagicData);
    }

    private int getDamage(LivingEntity caster) {
        return (int)this.getSpellPower((Entity)caster);
    }
}

