/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.ice;

import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.entity.mobs.SummonedPolarBear;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.DefaultConfig;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellRarity;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.Component;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.Level;

public class SummonPolarBearSpell
extends AbstractSpell {
    public static DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchool(SchoolType.ICE).setMaxLevel(10).setCooldownSeconds(180.0).build();

    public SummonPolarBearSpell() {
        this(1);
    }

    @Override
    public List<MutableComponent> getUniqueInfo(LivingEntity caster) {
        return List.of(Component.translatable("ui.irons_spellbooks.hp", Float.valueOf(this.getBearHealth(null))), Component.translatable("ui.irons_spellbooks.damage", Float.valueOf(this.getBearDamage(null))));
    }

    public SummonPolarBearSpell(int level) {
        super(SpellType.SUMMON_POLAR_BEAR_SPELL);
        this.level = level;
        this.manaCostPerLevel = 10;
        this.baseSpellPower = 4;
        this.spellPowerPerLevel = 1;
        this.castTime = 20;
        this.baseManaCost = 50;
    }

    @Override
    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of(SoundEvents.f_11868_);
    }

    @Override
    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of(SoundEvents.f_11862_);
    }

    @Override
    public void onCast(Level world, LivingEntity entity, PlayerMagicData playerMagicData) {
        int summonTime = 12000;
        SummonedPolarBear polarBear = new SummonedPolarBear(world, entity);
        polarBear.m_146884_(entity.m_20182_());
        polarBear.m_21204_().m_22146_(Attributes.f_22281_).m_22100_((double)this.getBearDamage(entity));
        polarBear.m_21204_().m_22146_(Attributes.f_22276_).m_22100_((double)this.getBearHealth(entity));
        polarBear.m_21153_(polarBear.m_21233_());
        world.m_7967_((Entity)polarBear);
        polarBear.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.POLAR_BEAR_TIMER.get(), summonTime, 0, false, false, false));
        int effectAmplifier = 0;
        if (entity.m_21023_((MobEffect)MobEffectRegistry.POLAR_BEAR_TIMER.get())) {
            effectAmplifier += entity.m_21124_((MobEffect)MobEffectRegistry.POLAR_BEAR_TIMER.get()).m_19564_() + 1;
        }
        entity.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.POLAR_BEAR_TIMER.get(), summonTime, effectAmplifier, false, false, true));
        super.onCast(world, entity, playerMagicData);
    }

    private float getBearHealth(LivingEntity caster) {
        return 20 + this.level * 4;
    }

    private float getBearDamage(LivingEntity caster) {
        return this.getSpellPower((Entity)caster);
    }
}

