/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.ice;

import io.redspace.ironsspellbooks.capabilities.magic.CastData;
import io.redspace.ironsspellbooks.capabilities.magic.CastTargetingData;
import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.entity.spells.ice_block.IceBlockProjectile;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.DefaultConfig;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellRarity;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.Component;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class IceBlockSpell
extends AbstractSpell {
    public static DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchool(SchoolType.ICE).setMaxLevel(6).setCooldownSeconds(15.0).build();

    public IceBlockSpell() {
        this(1);
    }

    @Override
    public List<MutableComponent> getUniqueInfo(LivingEntity caster) {
        return List.of(Component.translatable("ui.irons_spellbooks.damage", Utils.stringTruncation(this.getSpellPower((Entity)caster), 1)));
    }

    public IceBlockSpell(int level) {
        super(SpellType.ICE_BLOCK_SPELL);
        this.level = level;
        this.manaCostPerLevel = 10;
        this.baseSpellPower = 8;
        this.spellPowerPerLevel = 2;
        this.castTime = 30;
        this.baseManaCost = 40;
    }

    @Override
    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)SoundRegistry.ICE_BLOCK_CAST.get());
    }

    @Override
    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.empty();
    }

    @Override
    public boolean checkPreCastConditions(Level level, LivingEntity entity, PlayerMagicData playerMagicData) {
        Utils.preCastTargetHelper(level, entity, playerMagicData, this.getSpellType(), 48, 0.35f, false);
        return true;
    }

    @Override
    public void onCast(Level level, LivingEntity entity, PlayerMagicData playerMagicData) {
        CastTargetingData castTargetingData;
        Vec3 spawn = null;
        LivingEntity target = null;
        CastData castData = playerMagicData.getAdditionalCastData();
        if (castData instanceof CastTargetingData && (target = (castTargetingData = (CastTargetingData)castData).getTarget((ServerLevel)level)) != null) {
            spawn = target.m_20182_();
        }
        if (spawn == null) {
            HitResult raycast = Utils.raycastForEntity(level, (Entity)entity, 32.0f, true, 0.25f);
            if (raycast.m_6662_() == HitResult.Type.ENTITY) {
                spawn = ((EntityHitResult)raycast).m_82443_().m_20182_();
                Entity entity2 = ((EntityHitResult)raycast).m_82443_();
                if (entity2 instanceof LivingEntity) {
                    LivingEntity livingEntity;
                    target = livingEntity = (LivingEntity)entity2;
                }
            } else {
                spawn = raycast.m_82450_().m_82546_(entity.m_20156_().m_82541_());
            }
        }
        IceBlockProjectile iceBlock = new IceBlockProjectile(level, entity, target);
        iceBlock.m_20219_(this.raiseWithCollision(spawn, 4, level));
        iceBlock.setAirTime(target == null ? 20 : 50);
        iceBlock.setDamage(this.getDamage(entity));
        level.m_7967_((Entity)iceBlock);
        super.onCast(level, entity, playerMagicData);
    }

    private Vec3 raiseWithCollision(Vec3 start, int blocks, Level level) {
        Vec3 raised;
        for (int i = 0; i < blocks && level.m_8055_(new BlockPos(raised = start.m_82520_(0.0, 1.0, 0.0))).m_60795_(); ++i) {
            start = raised;
        }
        return start;
    }

    private float getDamage(LivingEntity entity) {
        return this.getSpellPower((Entity)entity);
    }
}

