/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.ice;

import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.DefaultConfig;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellRarity;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.Component;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class FrostbiteSpell
extends AbstractSpell {
    public static DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.COMMON).setSchool(SchoolType.ICE).setMaxLevel(0).setCooldownSeconds(0.0).build();

    public FrostbiteSpell() {
        this(1);
    }

    @Override
    public List<MutableComponent> getUniqueInfo(LivingEntity caster) {
        return List.of(Component.translatable("ui.irons_spellbooks.frostbite_success_chance", Utils.stringTruncation(this.getSpellPower((Entity)caster), 1)));
    }

    public FrostbiteSpell(int level) {
        super(SpellType.FROSTBITE_SPELL);
        this.level = level;
        this.manaCostPerLevel = 50;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 3;
        this.castTime = 0;
        this.baseManaCost = 100;
    }

    @Override
    public Optional<SoundEvent> getCastStartSound() {
        return Optional.empty();
    }

    @Override
    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.empty();
    }

    @Override
    public void onCast(Level level, LivingEntity entity, PlayerMagicData playerMagicData) {
        Entity target;
        HitResult raycast = Utils.raycastForEntity(level, (Entity)entity, 48.0f, true);
        if (raycast.m_6662_() == HitResult.Type.ENTITY && (target = ((EntityHitResult)raycast).m_82443_()) instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            float threshold = this.getSpellPower((Entity)entity);
            float hpPercent = livingTarget.m_21223_() / livingTarget.m_21233_();
            boolean success = false;
            if (livingTarget.m_21223_() <= threshold) {
                success = true;
            }
        }
        super.onCast(level, entity, playerMagicData);
    }
}

