/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.ice;

import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.entity.mobs.frozen_humanoid.FrozenHumanoid;
import io.redspace.ironsspellbooks.network.spell.ClientboundFrostStepParticles;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.setup.Messages;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.DefaultConfig;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellRarity;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.spells.ender.TeleportSpell;
import io.redspace.ironsspellbooks.util.AnimationHolder;
import io.redspace.ironsspellbooks.util.Component;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class FrostStepSpell
extends AbstractSpell {
    public static DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchool(SchoolType.ICE).setMaxLevel(8).setCooldownSeconds(10.0).build();

    public FrostStepSpell() {
        this(1);
    }

    @Override
    public List<MutableComponent> getUniqueInfo(LivingEntity caster) {
        return List.of(Component.translatable("ui.irons_spellbooks.distance", Utils.stringTruncation(this.getDistance((Entity)caster), 1)), Component.translatable("ui.irons_spellbooks.shatter_damage", Utils.stringTruncation(this.getDamage((Entity)caster), 1)));
    }

    public FrostStepSpell(int level) {
        super(SpellType.FROST_STEP_SPELL);
        this.level = level;
        this.baseSpellPower = 14;
        this.spellPowerPerLevel = 3;
        this.baseManaCost = 15;
        this.manaCostPerLevel = 3;
        this.castTime = 0;
    }

    @Override
    public Optional<SoundEvent> getCastStartSound() {
        return Optional.empty();
    }

    @Override
    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)SoundRegistry.FROST_STEP.get());
    }

    @Override
    public void onCast(Level level, LivingEntity entity, PlayerMagicData playerMagicData) {
        TeleportSpell.TeleportData teleportData = (TeleportSpell.TeleportData)playerMagicData.getAdditionalCastData();
        FrozenHumanoid shadow = new FrozenHumanoid(level, entity);
        shadow.setShatterDamage(this.getDamage((Entity)entity));
        shadow.setDeathTimer(60);
        level.m_7967_((Entity)shadow);
        Vec3 dest = null;
        if (teleportData != null) {
            Vec3 potentialTarget;
            dest = potentialTarget = teleportData.getTeleportTargetPosition();
        }
        if (dest == null) {
            dest = this.findTeleportLocation(level, entity);
        }
        Messages.sendToPlayersTrackingEntity(new ClientboundFrostStepParticles(entity.m_20182_(), dest), (Entity)entity, true);
        if (entity.m_20159_()) {
            entity.m_8127_();
        }
        entity.m_6021_(dest.f_82479_, dest.f_82480_, dest.f_82481_);
        entity.m_183634_();
        level.m_6263_(null, dest.f_82479_, dest.f_82480_, dest.f_82481_, this.getCastFinishSound().get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        playerMagicData.resetAdditionalCastData();
        super.onCast(level, entity, playerMagicData);
    }

    private Vec3 findTeleportLocation(Level level, LivingEntity entity) {
        return TeleportSpell.findTeleportLocation(level, entity, this.getDistance((Entity)entity));
    }

    public static void particleCloud(Level level, Vec3 pos) {
        if (level.f_46443_) {
            double width = 0.5;
            float height = 1.0f;
            for (int i = 0; i < 25; ++i) {
                double x = pos.f_82479_ + level.f_46441_.nextDouble() * width * 2.0 - width;
                double y = pos.f_82480_ + (double)height + level.f_46441_.nextDouble() * (double)height * 1.2 * 2.0 - (double)height * 1.2;
                double z = pos.f_82481_ + level.f_46441_.nextDouble() * width * 2.0 - width;
                double dx = level.f_46441_.nextDouble() * 0.1 * (double)(level.f_46441_.nextBoolean() ? 1 : -1);
                double dy = level.f_46441_.nextDouble() * 0.1 * (double)(level.f_46441_.nextBoolean() ? 1 : -1);
                double dz = level.f_46441_.nextDouble() * 0.1 * (double)(level.f_46441_.nextBoolean() ? 1 : -1);
                level.m_6493_(ParticleHelper.SNOWFLAKE, true, x, y, z, dx, dy, dz);
                level.m_6493_((ParticleOptions)ParticleTypes.f_175821_, true, x, y, z, -dx, -dy, -dz);
            }
        }
    }

    private float getDistance(Entity sourceEntity) {
        return this.getSpellPower(sourceEntity) * 0.65f;
    }

    private float getDamage(Entity caster) {
        return this.getSpellPower(caster) / 3.0f;
    }

    @Override
    public AnimationHolder getCastStartAnimation() {
        return AnimationHolder.none();
    }
}

