/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.holy;

import io.redspace.ironsspellbooks.capabilities.magic.CastData;
import io.redspace.ironsspellbooks.capabilities.magic.CastTargetingData;
import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.entity.spells.HealingAoe;
import io.redspace.ironsspellbooks.entity.spells.target_area.TargetedAreaEntity;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.DefaultConfig;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellRarity;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.AnimationHolder;
import io.redspace.ironsspellbooks.util.Component;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class HealingCircleSpell
extends AbstractSpell {
    public static DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.COMMON).setSchool(SchoolType.HOLY).setMaxLevel(10).setCooldownSeconds(25.0).build();

    public HealingCircleSpell() {
        this(1);
    }

    @Override
    public List<MutableComponent> getUniqueInfo(LivingEntity caster) {
        return List.of(Component.translatable("ui.irons_spellbooks.aoe_healing", Utils.stringTruncation(this.getHealing(caster), 2)), Component.translatable("ui.irons_spellbooks.radius", Utils.stringTruncation(this.getRadius(caster), 1)), Component.translatable("ui.irons_spellbooks.duration", Utils.timeFromTicks(this.getDuration(caster), 1)));
    }

    public HealingCircleSpell(int level) {
        super(SpellType.HEALING_CIRCLE_SPELL);
        this.setLevel(level);
        this.manaCostPerLevel = 10;
        this.baseSpellPower = 2;
        this.spellPowerPerLevel = 1;
        this.castTime = 20;
        this.baseManaCost = 40;
    }

    @Override
    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)SoundRegistry.CLOUD_OF_REGEN_LOOP.get());
    }

    @Override
    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.empty();
    }

    @Override
    public boolean checkPreCastConditions(Level level, LivingEntity entity, PlayerMagicData playerMagicData) {
        Utils.preCastTargetHelper(level, entity, playerMagicData, this.getSpellType(), 32, 0.15f, false);
        return true;
    }

    @Override
    public void onCast(Level world, LivingEntity entity, PlayerMagicData playerMagicData) {
        CastTargetingData castTargetingData;
        LivingEntity target;
        Vec3 spawn = null;
        CastData castData = playerMagicData.getAdditionalCastData();
        if (castData instanceof CastTargetingData && (target = (castTargetingData = (CastTargetingData)castData).getTarget((ServerLevel)world)) != null) {
            spawn = target.m_20182_();
        }
        if (spawn == null) {
            spawn = Utils.raycastForEntity(world, (Entity)entity, 32.0f, true, 0.15f).m_82450_();
        }
        int duration = this.getDuration(entity);
        float radius = this.getRadius(entity);
        TargetedAreaEntity visualEntity = TargetedAreaEntity.createTargetAreaEntity(world, spawn, radius, 0xC80000);
        visualEntity.setDuration(duration);
        HealingAoe aoeEntity = new HealingAoe(world);
        aoeEntity.m_5602_((Entity)entity);
        aoeEntity.setCircular();
        aoeEntity.setRadius(radius);
        aoeEntity.setDuration(duration);
        aoeEntity.setDamage(this.getHealing(entity));
        aoeEntity.m_146884_(spawn);
        world.m_7967_((Entity)aoeEntity);
        super.onCast(world, entity, playerMagicData);
    }

    private float getHealing(LivingEntity caster) {
        return this.getSpellPower((Entity)caster) * 0.25f;
    }

    private float getRadius(LivingEntity caster) {
        return 4.0f;
    }

    private int getDuration(LivingEntity caster) {
        return 200;
    }

    @Override
    public AnimationHolder getCastStartAnimation() {
        return ANIMATION_CONTINUOUS_OVERHEAD;
    }
}

