/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.holy;

import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.DefaultConfig;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellRarity;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.AnimationHolder;
import io.redspace.ironsspellbooks.util.Component;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import software.bernie.geckolib3.core.builder.ILoopType;

public class HealSpell
extends AbstractSpell {
    final float twoPi = 6.283f;
    public static DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.COMMON).setSchool(SchoolType.HOLY).setMaxLevel(10).setCooldownSeconds(25.0).build();
    public static final AnimationHolder SELF_CAST_ANIMATION = new AnimationHolder("instant_self", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);

    public HealSpell() {
        this(1);
    }

    @Override
    public List<MutableComponent> getUniqueInfo(LivingEntity caster) {
        return List.of(Component.translatable("ui.irons_spellbooks.healing", Utils.stringTruncation(this.getSpellPower((Entity)caster), 1)));
    }

    public HealSpell(int level) {
        super(SpellType.HEAL_SPELL);
        this.level = level;
        this.manaCostPerLevel = 10;
        this.baseSpellPower = 6;
        this.spellPowerPerLevel = 1;
        this.castTime = 0;
        this.baseManaCost = 30;
    }

    @Override
    public Optional<SoundEvent> getCastStartSound() {
        return Optional.empty();
    }

    @Override
    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.empty();
    }

    @Override
    public void onCast(Level world, LivingEntity entity, PlayerMagicData playerMagicData) {
        entity.m_5634_(this.getSpellPower((Entity)entity));
        int count = 16;
        float radius = 1.25f;
        for (int i = 0; i < count; ++i) {
            double theta = Math.toRadians(360 / count) * (double)i;
            double x = Math.cos(theta) * (double)radius;
            double z = Math.sin(theta) * (double)radius;
            MagicManager.spawnParticles(world, (ParticleOptions)ParticleTypes.f_123750_, entity.m_20182_().f_82479_ + x, entity.m_20182_().f_82480_, entity.m_20182_().f_82481_ + z, 1, 0.0, 0.0, 0.0, 0.1, false);
        }
        super.onCast(world, entity, playerMagicData);
    }

    @Override
    public AnimationHolder getCastStartAnimation() {
        return SELF_CAST_ANIMATION;
    }
}

