/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.holy;

import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.entity.spells.target_area.TargetedAreaEntity;
import io.redspace.ironsspellbooks.network.spell.ClientboundAborptionParticles;
import io.redspace.ironsspellbooks.network.spell.ClientboundFortifyAreaParticles;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.setup.Messages;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.DefaultConfig;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellRarity;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.spells.TargetAreaCastData;
import io.redspace.ironsspellbooks.util.Component;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.Nullable;

public class FortifySpell
extends AbstractSpell {
    public static final float radius = 16.0f;
    public static DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.COMMON).setSchool(SchoolType.HOLY).setMaxLevel(10).setCooldownSeconds(35.0).build();

    public FortifySpell() {
        this(1);
    }

    @Override
    public List<MutableComponent> getUniqueInfo(LivingEntity caster) {
        return List.of(Component.translatable("ui.irons_spellbooks.absorption", Utils.stringTruncation(this.getSpellPower((Entity)caster), 0)), Component.translatable("ui.irons_spellbooks.radius", Utils.stringTruncation(16.0, 1)));
    }

    public FortifySpell(int level) {
        super(SpellType.FORTIFY_SPELL);
        this.level = level;
        this.manaCostPerLevel = 5;
        this.baseSpellPower = 6;
        this.spellPowerPerLevel = 1;
        this.castTime = 40;
        this.baseManaCost = 40;
    }

    @Override
    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)SoundRegistry.CLOUD_OF_REGEN_LOOP.get());
    }

    @Override
    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.empty();
    }

    @Override
    public void onServerPreCast(Level level, LivingEntity entity, @Nullable PlayerMagicData playerMagicData) {
        super.onServerPreCast(level, entity, playerMagicData);
        if (playerMagicData == null) {
            return;
        }
        TargetedAreaEntity targetedAreaEntity = TargetedAreaEntity.createTargetAreaEntity(level, entity.m_20182_(), 16.0f, 16239960);
        targetedAreaEntity.setOwner(entity);
        playerMagicData.setAdditionalCastData(new TargetAreaCastData(entity.m_20182_(), targetedAreaEntity));
    }

    @Override
    public void onCast(Level level, LivingEntity entity, PlayerMagicData playerMagicData) {
        level.m_45976_(LivingEntity.class, new AABB(entity.m_20182_().m_82492_(16.0, 16.0, 16.0), entity.m_20182_().m_82520_(16.0, 16.0, 16.0))).forEach(target -> {
            if (Utils.shouldHealEntity(entity, target) && entity.m_20270_((Entity)target) <= 16.0f) {
                target.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.FORTIFY.get(), 2400, (int)this.getSpellPower((Entity)entity), false, false, true));
                Messages.sendToPlayersTrackingEntity(new ClientboundAborptionParticles(target.m_20182_()), (Entity)entity, true);
            }
        });
        Messages.sendToPlayersTrackingEntity(new ClientboundFortifyAreaParticles(entity.m_20182_()), (Entity)entity, true);
        super.onCast(level, entity, playerMagicData);
    }
}

