/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.holy;

import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.network.spell.ClientboundHealParticles;
import io.redspace.ironsspellbooks.network.spell.ClientboundRegenCloudParticles;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.setup.Messages;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.DefaultConfig;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellRarity;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.Component;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class CloudOfRegenerationSpell
extends AbstractSpell {
    public static final float radius = 5.0f;
    public static DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.COMMON).setSchool(SchoolType.HOLY).setMaxLevel(5).setCooldownSeconds(35.0).build();

    public CloudOfRegenerationSpell() {
        this(1);
    }

    @Override
    public List<MutableComponent> getUniqueInfo(LivingEntity caster) {
        return List.of(Component.translatable("ui.irons_spellbooks.healing", Utils.stringTruncation(this.getHealing((Entity)caster), 1)), Component.translatable("ui.irons_spellbooks.radius", Utils.stringTruncation(5.0, 1)));
    }

    public CloudOfRegenerationSpell(int level) {
        super(SpellType.CLOUD_OF_REGENERATION_SPELL);
        this.level = level;
        this.manaCostPerLevel = 3;
        this.baseSpellPower = 2;
        this.spellPowerPerLevel = 1;
        this.castTime = 200;
        this.baseManaCost = 10;
    }

    private float getHealing(Entity caster) {
        return this.getSpellPower(caster) * 0.5f;
    }

    @Override
    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)SoundRegistry.HOLY_CAST.get());
    }

    @Override
    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)SoundRegistry.CLOUD_OF_REGEN_LOOP.get());
    }

    @Override
    public void onCast(Level level, LivingEntity entity, PlayerMagicData playerMagicData) {
        level.m_45976_(LivingEntity.class, entity.m_142469_().m_82400_(5.0)).forEach(target -> {
            if (target.m_20238_(entity.m_20182_()) < 25.0 && Utils.shouldHealEntity(entity, target)) {
                target.m_5634_(this.getHealing((Entity)entity));
                Messages.sendToPlayersTrackingEntity(new ClientboundHealParticles(target.m_20182_()), (Entity)entity, true);
            }
        });
        Messages.sendToPlayersTrackingEntity(new ClientboundRegenCloudParticles(entity.m_20182_()), (Entity)entity, true);
        super.onCast(level, entity, playerMagicData);
    }

    @Override
    public void onClientPreCast(Level level, LivingEntity entity, InteractionHand hand, @Nullable PlayerMagicData playerMagicData) {
        super.onClientPreCast(level, entity, hand, playerMagicData);
    }
}

