/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.holy;

import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.DefaultConfig;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellRarity;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.Component;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class AngelWingsSpell
extends AbstractSpell {
    public static DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.EPIC).setSchool(SchoolType.HOLY).setMaxLevel(5).setCooldownSeconds(120.0).build();

    public AngelWingsSpell() {
        this(1);
    }

    @Override
    public List<MutableComponent> getUniqueInfo(LivingEntity caster) {
        return List.of(Component.translatable("ui.irons_spellbooks.effect_length", Utils.timeFromTicks(this.getSpellPower((Entity)caster) * 20.0f, 1)));
    }

    public AngelWingsSpell(int level) {
        super(SpellType.ANGEL_WING_SPELL);
        this.level = level;
        this.manaCostPerLevel = 20;
        this.baseSpellPower = 30;
        this.spellPowerPerLevel = 30;
        this.castTime = 0;
        this.baseManaCost = 60;
    }

    private int getEffectDuration(LivingEntity entity) {
        return (int)this.getSpellPower((Entity)entity) * 20;
    }

    @Override
    public Optional<SoundEvent> getCastStartSound() {
        return Optional.empty();
    }

    @Override
    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.empty();
    }

    @Override
    public void onCast(Level world, LivingEntity entity, PlayerMagicData playerMagicData) {
        entity.m_147207_(new MobEffectInstance((MobEffect)MobEffectRegistry.ANGEL_WINGS.get(), this.getEffectDuration(entity)), (Entity)entity);
        super.onCast(world, entity, playerMagicData);
    }
}

