/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.fire;

import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.entity.spells.firebolt.FireboltProjectile;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.DefaultConfig;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellRarity;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.Component;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class FireboltSpell
extends AbstractSpell {
    public static DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.COMMON).setSchool(SchoolType.FIRE).setMaxLevel(10).setCooldownSeconds(1.0).build();

    public FireboltSpell() {
        this(1);
    }

    @Override
    public List<MutableComponent> getUniqueInfo(LivingEntity caster) {
        return List.of(Component.translatable("ui.irons_spellbooks.damage", Utils.stringTruncation(this.getDamage(caster), 1)));
    }

    public FireboltSpell(int level) {
        super(SpellType.FIREBOLT_SPELL);
        this.level = level;
        this.manaCostPerLevel = 2;
        this.baseSpellPower = 12;
        this.spellPowerPerLevel = 1;
        this.castTime = 0;
        this.baseManaCost = 10;
    }

    @Override
    public Optional<SoundEvent> getCastStartSound() {
        return Optional.empty();
    }

    @Override
    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.empty();
    }

    @Override
    public void onCast(Level world, LivingEntity entity, PlayerMagicData playerMagicData) {
        FireboltProjectile firebolt = new FireboltProjectile(world, entity);
        firebolt.m_146884_(entity.m_20182_().m_82520_(0.0, (double)entity.m_20192_() - firebolt.m_142469_().m_82376_() * 0.5, 0.0));
        firebolt.shoot(entity.m_20154_());
        firebolt.setDamage(this.getDamage(entity));
        world.m_7967_((Entity)firebolt);
        super.onCast(world, entity, playerMagicData);
    }

    private float getDamage(LivingEntity entity) {
        return this.getSpellPower((Entity)entity) * 0.5f;
    }
}

