/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.fire;

import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.entity.spells.fireball.MagicFireball;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.DefaultConfig;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellRarity;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.Component;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class FireballSpell
extends AbstractSpell {
    public static DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.EPIC).setSchool(SchoolType.FIRE).setMaxLevel(3).setCooldownSeconds(25.0).build();

    public FireballSpell() {
        this(1);
    }

    @Override
    public List<MutableComponent> getUniqueInfo(LivingEntity caster) {
        return List.of(Component.translatable("ui.irons_spellbooks.damage", Utils.stringTruncation(this.getDamage((Entity)caster), 1)), Component.translatable("ui.irons_spellbooks.radius", this.getRadius((Entity)caster)));
    }

    public FireballSpell(int level) {
        super(SpellType.FIREBALL_SPELL);
        this.level = level;
        this.manaCostPerLevel = 15;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 40;
        this.baseManaCost = 60;
    }

    @Override
    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)SoundRegistry.FIREBALL_START.get());
    }

    @Override
    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.empty();
    }

    @Override
    public void onCast(Level world, LivingEntity entity, PlayerMagicData playerMagicData) {
        Vec3 origin = entity.m_146892_();
        MagicFireball fireball = new MagicFireball(world, entity);
        fireball.setDamage(this.getDamage((Entity)entity));
        fireball.setExplosionRadius(this.getRadius((Entity)entity));
        fireball.m_146884_(origin.m_82549_(entity.m_20156_()).m_82492_(0.0, (double)(fireball.m_20206_() / 2.0f), 0.0));
        fireball.shoot(entity.m_20154_());
        world.m_7967_((Entity)fireball);
        super.onCast(world, entity, playerMagicData);
    }

    public float getDamage(Entity caster) {
        return 10.0f * this.getSpellPower(caster);
    }

    public int getRadius(Entity caster) {
        return (int)this.getSpellPower(caster);
    }
}

