/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.fire;

import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.entity.spells.magma_ball.FireBomb;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.DefaultConfig;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellRarity;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.Component;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class FireBombSpell
extends AbstractSpell {
    public static DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.UNCOMMON).setSchool(SchoolType.FIRE).setMaxLevel(8).setCooldownSeconds(12.0).build();

    @Override
    public List<MutableComponent> getUniqueInfo(LivingEntity caster) {
        return List.of(Component.translatable("ui.irons_spellbooks.damage", Utils.stringTruncation(this.getDamage(caster), 1)), Component.translatable("ui.irons_spellbooks.aoe_damage", Utils.stringTruncation(this.getDamage(caster) / 5.0f, 1)), Component.translatable("ui.irons_spellbooks.radius", Utils.stringTruncation(this.getRadius(caster), 1)));
    }

    public FireBombSpell(int level) {
        super(SpellType.FIRE_BOMB_SPELL);
        this.setLevel(level);
        this.manaCostPerLevel = 5;
        this.baseSpellPower = 8;
        this.spellPowerPerLevel = 1;
        this.castTime = 20;
        this.baseManaCost = 30;
    }

    @Override
    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)SoundRegistry.FIRE_BOMB_CHARGE.get());
    }

    @Override
    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)SoundRegistry.FIRE_BOMB_CAST.get());
    }

    @Override
    public void onCast(Level level, LivingEntity entity, PlayerMagicData playerMagicData) {
        FireBomb orb = new FireBomb(level, entity);
        orb.m_146884_(entity.m_20182_().m_82520_(0.0, (double)entity.m_20192_() - orb.m_142469_().m_82376_() * 0.5, 0.0).m_82549_(entity.m_20156_()));
        orb.shoot(entity.m_20154_());
        orb.m_20256_(orb.m_20184_().m_82520_(0.0, 0.2, 0.0));
        orb.setExplosionRadius(this.getRadius(entity));
        orb.setDamage(this.getDamage(entity));
        level.m_7967_((Entity)orb);
        super.onCast(level, entity, playerMagicData);
    }

    public float getRadius(LivingEntity caster) {
        return 5.0f;
    }

    public float getDamage(LivingEntity caster) {
        return this.getSpellPower((Entity)caster);
    }
}

