/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.fire;

import io.redspace.ironsspellbooks.capabilities.magic.CastData;
import io.redspace.ironsspellbooks.capabilities.magic.CastDataSerializable;
import io.redspace.ironsspellbooks.capabilities.magic.ImpulseCastData;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import io.redspace.ironsspellbooks.player.SpinAttackType;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.DefaultConfig;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellRarity;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.Component;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class BurningDashSpell
extends AbstractSpell {
    public static DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.COMMON).setSchool(SchoolType.FIRE).setMaxLevel(10).setCooldownSeconds(10.0).build();

    @Override
    public List<MutableComponent> getUniqueInfo(LivingEntity caster) {
        return List.of(Component.translatable("ui.irons_spellbooks.damage", Utils.stringTruncation(this.getDamage(caster), 1)));
    }

    public BurningDashSpell() {
        this(1);
    }

    public BurningDashSpell(int level) {
        super(SpellType.BURNING_DASH_SPELL);
        this.level = level;
        this.manaCostPerLevel = 2;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 0;
        this.baseManaCost = 20;
    }

    @Override
    public void onClientCast(Level level, LivingEntity entity, CastData castData) {
        if (castData instanceof ImpulseCastData) {
            ImpulseCastData bdcd = (ImpulseCastData)castData;
            entity.f_19812_ = bdcd.hasImpulse;
            entity.m_20256_(entity.m_20184_().m_82520_((double)bdcd.x, (double)bdcd.y, (double)bdcd.z));
        }
        super.onClientCast(level, entity, castData);
    }

    @Override
    public CastDataSerializable getEmptyCastData() {
        return new ImpulseCastData();
    }

    @Override
    public Optional<SoundEvent> getCastStartSound() {
        return Optional.empty();
    }

    @Override
    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.empty();
    }

    @Override
    public void onCast(Level world, LivingEntity entity, PlayerMagicData playerMagicData) {
        entity.f_19812_ = true;
        float multiplier = (15.0f + this.getSpellPower((Entity)entity)) / 12.0f;
        Vec3 forward = entity.m_20154_();
        if (playerMagicData.getAdditionalCastData() instanceof BurningDashDirectionOverrideCastData) {
            forward = world.f_46441_.nextBoolean() ? forward.m_82524_(90.0f) : forward.m_82524_(-90.0f);
        }
        Vec3 vec = forward.m_82542_(3.0, 1.0, 3.0).m_82541_().m_82520_(0.0, 0.25, 0.0).m_82490_((double)multiplier);
        playerMagicData.setAdditionalCastData(new ImpulseCastData((float)vec.f_82479_, (float)vec.f_82480_, (float)vec.f_82481_, true));
        entity.m_20256_(entity.m_20184_().m_82549_(vec));
        if (entity.m_20096_()) {
            entity.m_146884_(entity.m_20182_().m_82520_(0.0, 1.2, 0.0));
        }
        this.startSpinAttack(entity, 5 + 2 * this.level);
        world.m_45933_((Entity)entity, entity.m_142469_().m_82400_(4.0)).forEach(target -> {
            if (target.m_20280_((Entity)entity) < 16.0 && DamageSources.applyDamage(target, this.getDamage(entity), SpellType.BURNING_DASH_SPELL.getDamageSource((Entity)entity), SchoolType.FIRE)) {
                target.m_20254_(3);
            }
        });
        MagicManager.spawnParticles(world, ParticleHelper.FIRE, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 75, 1.0, 0.0, 1.0, 0.08, false);
        playerMagicData.getSyncedData().setSpinAttackType(SpinAttackType.FIRE);
        super.onCast(world, entity, playerMagicData);
    }

    private float getDamage(LivingEntity caster) {
        return 5.0f + this.getSpellPower((Entity)caster) / 2.0f;
    }

    private void startSpinAttack(LivingEntity entity, int durationInTicks) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.m_204079_(durationInTicks);
        } else if (entity instanceof AbstractSpellCastingMob) {
            AbstractSpellCastingMob mob = (AbstractSpellCastingMob)entity;
            mob.startAutoSpinAttack(durationInTicks);
        }
    }

    public static class BurningDashDirectionOverrideCastData
    implements CastData {
        @Override
        public void reset() {
        }
    }
}

