/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.evocation;

import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.entity.spells.spectral_hammer.SpectralHammer;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.DefaultConfig;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellRarity;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.Component;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class SpectralHammerSpell
extends AbstractSpell {
    private static final int distance = 12;
    public static DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.UNCOMMON).setSchool(SchoolType.EVOCATION).setMaxLevel(5).setCooldownSeconds(10.0).build();

    public SpectralHammerSpell() {
        this(1);
    }

    @Override
    public List<MutableComponent> getUniqueInfo(LivingEntity caster) {
        return List.of(Component.translatable("ui.irons_spellbooks.dimensions", 1 + this.getRadius(caster) * 2, 1 + this.getRadius(caster) * 2, this.getDepth(caster) + 1), Component.translatable("ui.irons_spellbooks.distance", 12));
    }

    public SpectralHammerSpell(int level) {
        super(SpellType.SPECTRAL_HAMMER_SPELL);
        this.level = level;
        this.manaCostPerLevel = 5;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 25;
        this.baseManaCost = 15;
    }

    @Override
    public Optional<SoundEvent> getCastStartSound() {
        return Optional.empty();
    }

    @Override
    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.empty();
    }

    @Override
    public boolean checkPreCastConditions(Level level, LivingEntity entity, PlayerMagicData playerMagicData) {
        return Utils.getTargetBlock(level, entity, ClipContext.Fluid.NONE, 12.0).m_6662_() == HitResult.Type.BLOCK;
    }

    @Override
    public void onCast(Level world, LivingEntity entity, PlayerMagicData playerMagicData) {
        BlockHitResult blockPosition = Utils.getTargetBlock(world, entity, ClipContext.Fluid.NONE, 12.0);
        Direction face = blockPosition.m_82434_();
        int radius = this.getRadius(entity);
        int depth = this.getDepth(entity);
        SpectralHammer spectralHammer = new SpectralHammer(world, entity, blockPosition, depth, radius);
        Vec3 position = Vec3.m_82512_((Vec3i)blockPosition.m_82425_());
        if (!face.m_122434_().m_122478_()) {
            position = position.m_82492_(0.0, 2.0, 0.0).m_82546_(entity.m_20156_().m_82541_().m_82490_(1.5));
        } else if (face == Direction.DOWN) {
            position = position.m_82492_(0.0, 3.0, 0.0);
        }
        spectralHammer.m_6034_(position.f_82479_, position.f_82480_, position.f_82481_);
        world.m_7967_((Entity)spectralHammer);
        super.onCast(world, entity, playerMagicData);
    }

    private int getDepth(LivingEntity caster) {
        return (int)this.getSpellPower((Entity)caster);
    }

    private int getRadius(LivingEntity caster) {
        return (int)Math.max(this.getSpellPower((Entity)caster) * 0.5f, 1.0f);
    }
}

