/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.evocation;

import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.entity.spells.ExtendedFireworkRocket;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.DefaultConfig;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellRarity;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.Component;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class FirecrackerSpell
extends AbstractSpell {
    public static DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.COMMON).setSchool(SchoolType.EVOCATION).setMaxLevel(10).setCooldownSeconds(1.5).build();
    private static final int[] DYE_COLORS = new int[]{11546150, 6192150, 3949738, 8991416, 1481884, 15961002, 8439583, 16701501, 3847130, 13061821, 16351261, 0xF9FFFE};

    public FirecrackerSpell() {
        this(1);
    }

    @Override
    public List<MutableComponent> getUniqueInfo(LivingEntity caster) {
        return List.of(Component.translatable("ui.irons_spellbooks.damage", Utils.stringTruncation(this.getSpellPower((Entity)caster), 1)));
    }

    public FirecrackerSpell(int level) {
        super(SpellType.FIRECRACKER_SPELL);
        this.level = level;
        this.manaCostPerLevel = 2;
        this.baseSpellPower = 4;
        this.spellPowerPerLevel = 1;
        this.castTime = 0;
        this.baseManaCost = 20;
    }

    @Override
    public Optional<SoundEvent> getCastStartSound() {
        return Optional.empty();
    }

    @Override
    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.empty();
    }

    @Override
    public void onCast(Level world, LivingEntity entity, PlayerMagicData playerMagicData) {
        Vec3 shootAngle = entity.m_20154_().m_82541_();
        float speed = 2.5f;
        Vec3 hitPos = Utils.raycastForEntity(world, (Entity)entity, this.getRange(entity), true).m_82450_();
        Vec3 spawn = hitPos.m_82546_(shootAngle.m_82490_(0.5));
        ExtendedFireworkRocket firework = new ExtendedFireworkRocket(world, this.randomFireworkRocket(), (Entity)entity, spawn.f_82479_, spawn.f_82480_, spawn.f_82481_, true, this.getDamage(entity));
        world.m_7967_((Entity)firework);
        firework.m_6686_(shootAngle.f_82479_, shootAngle.f_82480_, shootAngle.f_82481_, speed, 0.0f);
        super.onCast(world, entity, playerMagicData);
    }

    private int getRange(LivingEntity entity) {
        return 15 + (int)(this.getSpellPower((Entity)entity) * 2.0f);
    }

    private float getDamage(LivingEntity entity) {
        return this.getSpellPower((Entity)entity) * 0.5f;
    }

    private ItemStack randomFireworkRocket() {
        Random random = new Random();
        ItemStack rocket = new ItemStack((ItemLike)Items.f_42688_);
        CompoundTag properties = new CompoundTag();
        ListTag explosions = new ListTag();
        CompoundTag explosion = new CompoundTag();
        explosion.m_128344_("Type", (byte)(random.nextInt(3) * 2));
        if (random.nextInt(3) == 0) {
            explosion.m_128344_("Trail", (byte)1);
        }
        if (random.nextInt(3) == 0) {
            explosion.m_128344_("Flicker", (byte)1);
        }
        explosion.m_128385_("Colors", this.randomColors());
        explosions.add((Object)explosion);
        properties.m_128365_("Explosions", (Tag)explosions);
        properties.m_128344_("Flight", (byte)-1);
        rocket.m_41700_("Fireworks", (Tag)properties);
        return rocket;
    }

    private int[] randomColors() {
        int[] colors = new int[3];
        Random random = new Random();
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = DYE_COLORS[random.nextInt(DYE_COLORS.length)];
        }
        return colors;
    }
}

