/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.evocation;

import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.entity.spells.ExtendedEvokerFang;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.DefaultConfig;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellRarity;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.Component;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class FangWardSpell
extends AbstractSpell {
    public static DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.COMMON).setSchool(SchoolType.EVOCATION).setMaxLevel(8).setCooldownSeconds(15.0).build();

    public FangWardSpell() {
        this(1);
    }

    @Override
    public List<MutableComponent> getUniqueInfo(LivingEntity caster) {
        return List.of(Component.translatable("ui.irons_spellbooks.ring_count", this.getRings()), Component.translatable("ui.irons_spellbooks.damage", Utils.stringTruncation(this.getDamage(caster), 1)));
    }

    public FangWardSpell(int level) {
        super(SpellType.FANG_WARD_SPELL);
        this.level = level;
        this.manaCostPerLevel = 5;
        this.baseSpellPower = 8;
        this.spellPowerPerLevel = 1;
        this.castTime = 20;
        this.baseManaCost = 45;
    }

    @Override
    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of(SoundEvents.f_11867_);
    }

    @Override
    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.empty();
    }

    @Override
    public void onCast(Level world, LivingEntity entity, PlayerMagicData playerMagicData) {
        int rings = this.getRings();
        int count = 5;
        Vec3 center = entity.m_146892_();
        for (int r = 0; r < rings; ++r) {
            float fangs = count + r * 2;
            int i = 0;
            while ((float)i < fangs) {
                Vec3 spawn = center.m_82549_(new Vec3(0.0, 0.0, 1.5 * (double)(r + 1)).m_82524_(entity.m_146908_() * ((float)Math.PI / 180) + 6.281f / fangs * (float)i));
                if (!world.m_8055_(new BlockPos(spawn = new Vec3(spawn.f_82479_, (double)Utils.findRelativeGroundLevel(world, spawn, 5), spawn.f_82481_)).m_7495_()).m_60795_()) {
                    ExtendedEvokerFang fang = new ExtendedEvokerFang(world, spawn.f_82479_, spawn.f_82480_, spawn.f_82481_, this.get2DAngle(center, spawn), r, entity, this.getDamage(entity));
                    world.m_7967_((Entity)fang);
                }
                ++i;
            }
        }
        super.onCast(world, entity, playerMagicData);
    }

    private float get2DAngle(Vec3 a, Vec3 b) {
        return Utils.getAngle(new Vec2((float)a.f_82479_, (float)a.f_82481_), new Vec2((float)b.f_82479_, (float)b.f_82481_));
    }

    private float getDamage(LivingEntity entity) {
        return this.getSpellPower((Entity)entity);
    }

    private int getRings() {
        return 2 + (this.level - 1) / 3;
    }
}

