/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.evocation;

import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.entity.spells.ExtendedEvokerFang;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.DefaultConfig;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellRarity;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.Component;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class FangStrikeSpell
extends AbstractSpell {
    public static DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.COMMON).setSchool(SchoolType.EVOCATION).setMaxLevel(10).setCooldownSeconds(5.0).build();

    public FangStrikeSpell() {
        this(1);
    }

    @Override
    public List<MutableComponent> getUniqueInfo(LivingEntity caster) {
        return List.of(Component.translatable("ui.irons_spellbooks.fang_count", this.getCount()), Component.translatable("ui.irons_spellbooks.damage", Utils.stringTruncation(this.getDamage(caster), 1)));
    }

    public FangStrikeSpell(int level) {
        super(SpellType.FANG_STRIKE_SPELL);
        this.level = level;
        this.manaCostPerLevel = 3;
        this.baseSpellPower = 6;
        this.spellPowerPerLevel = 1;
        this.castTime = 20;
        this.baseManaCost = 30;
    }

    @Override
    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of(SoundEvents.f_11867_);
    }

    @Override
    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.empty();
    }

    @Override
    public void onCast(Level world, LivingEntity entity, PlayerMagicData playerMagicData) {
        Vec3 forward = entity.m_20156_().m_82542_(1.0, 0.0, 1.0).m_82541_();
        Vec3 start = entity.m_146892_().m_82549_(forward.m_82490_(1.5));
        for (int i = 0; i < this.getCount(); ++i) {
            Vec3 spawn = start.m_82549_(forward.m_82490_((double)i));
            if (world.m_8055_(new BlockPos(spawn = new Vec3(spawn.f_82479_, (double)this.getGroundLevel(world, spawn, 8), spawn.f_82481_)).m_7495_()).m_60795_()) continue;
            ExtendedEvokerFang fang = new ExtendedEvokerFang(world, spawn.f_82479_, spawn.f_82480_, spawn.f_82481_, (entity.m_146908_() - 90.0f) * ((float)Math.PI / 180), i, entity, this.getDamage(entity));
            world.m_7967_((Entity)fang);
        }
        super.onCast(world, entity, playerMagicData);
    }

    private int getGroundLevel(Level level, Vec3 start, int maxSteps) {
        if (!level.m_8055_(new BlockPos(start)).m_60795_()) {
            for (int i = 0; i < maxSteps && !level.m_8055_(new BlockPos(start = start.m_82520_(0.0, 1.0, 0.0))).m_60795_(); ++i) {
            }
        }
        Vec3 lower = level.m_45547_(new ClipContext(start, start.m_82520_(0.0, (double)(maxSteps * -2), 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null)).m_82450_();
        return (int)lower.f_82480_;
    }

    private int getCount() {
        return 5 + this.level;
    }

    private float getDamage(LivingEntity entity) {
        return this.getSpellPower((Entity)entity);
    }
}

