/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.evocation;

import io.redspace.ironsspellbooks.capabilities.magic.CastData;
import io.redspace.ironsspellbooks.capabilities.magic.CastTargetingData;
import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.entity.spells.creeper_head.CreeperHeadProjectile;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.DefaultConfig;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellRarity;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.Component;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class ChainCreeperSpell
extends AbstractSpell {
    public static DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.UNCOMMON).setSchool(SchoolType.EVOCATION).setMaxLevel(6).setCooldownSeconds(15.0).build();

    public ChainCreeperSpell() {
        this(1);
    }

    @Override
    public List<MutableComponent> getUniqueInfo(LivingEntity caster) {
        return List.of(Component.translatable("ui.irons_spellbooks.damage", Utils.stringTruncation(this.getSpellPower((Entity)caster), 1)), Component.translatable("ui.irons_spellbooks.projectile_count", this.getCount()));
    }

    public ChainCreeperSpell(int level) {
        super(SpellType.CHAIN_CREEPER_SPELL);
        this.level = level;
        this.manaCostPerLevel = 10;
        this.baseSpellPower = 5;
        this.spellPowerPerLevel = 0;
        this.castTime = 30;
        this.baseManaCost = 40;
    }

    @Override
    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of(SoundEvents.f_11837_);
    }

    @Override
    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of(SoundEvents.f_11862_);
    }

    @Override
    public boolean checkPreCastConditions(Level level, LivingEntity entity, PlayerMagicData playerMagicData) {
        Utils.preCastTargetHelper(level, entity, playerMagicData, this.getSpellType(), 48, 0.25f, false);
        return true;
    }

    @Override
    public void onCast(Level level, LivingEntity entity, PlayerMagicData playerMagicData) {
        Vec3 spawn = null;
        CastData castData = playerMagicData.getAdditionalCastData();
        if (castData instanceof CastTargetingData) {
            CastTargetingData castTargetingData = (CastTargetingData)castData;
            spawn = castTargetingData.getTargetPosition((ServerLevel)level);
        }
        if (spawn == null) {
            HitResult raycast = Utils.raycastForEntity(level, (Entity)entity, 32.0f, true);
            spawn = raycast.m_6662_() == HitResult.Type.ENTITY ? ((EntityHitResult)raycast).m_82443_().m_20182_() : Utils.moveToRelativeGroundLevel(level, raycast.m_82450_().m_82546_(entity.m_20156_().m_82541_()).m_82520_(0.0, 2.0, 0.0), 5);
        }
        ChainCreeperSpell.summonCreeperRing(level, entity, spawn.m_82520_(0.0, 0.5, 0.0), this.getDamage(entity), this.getCount());
        super.onCast(level, entity, playerMagicData);
    }

    public static void summonCreeperRing(Level level, LivingEntity owner, Vec3 origin, float damage, int count) {
        int degreesPerCreeper = 360 / count;
        for (int i = 0; i < count; ++i) {
            Vec3 motion = new Vec3(0.0, 0.0, 0.3 + (double)((float)count * 0.01f));
            motion = motion.m_82496_(1.3089969f);
            motion = motion.m_82524_((float)(degreesPerCreeper * i) * ((float)Math.PI / 180));
            CreeperHeadProjectile head = new CreeperHeadProjectile(owner, level, motion, damage);
            head.setChainOnKill(true);
            Vec3 spawn = origin.m_82549_(motion.m_82542_(1.0, 0.0, 1.0).m_82541_().m_82490_((double)0.3f));
            Vec2 angle = Utils.rotationFromDirection(motion);
            head.m_7678_(spawn.f_82479_, spawn.f_82480_ - head.m_142469_().m_82376_() / 2.0, spawn.f_82481_, angle.f_82471_, angle.f_82470_);
            level.m_7967_((Entity)head);
        }
    }

    private int getCount() {
        return 3 + this.level - 1;
    }

    private float getDamage(LivingEntity entity) {
        return this.getSpellPower((Entity)entity);
    }
}

