/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.ender;

import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.capabilities.magic.CastData;
import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.network.spell.ClientboundTeleportParticles;
import io.redspace.ironsspellbooks.setup.Messages;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.DefaultConfig;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellRarity;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.AnimationHolder;
import io.redspace.ironsspellbooks.util.Component;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class TeleportSpell
extends AbstractSpell {
    public static DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.UNCOMMON).setSchool(SchoolType.ENDER).setMaxLevel(5).setCooldownSeconds(3.0).build();

    public TeleportSpell() {
        this(1);
    }

    public TeleportSpell(int level) {
        super(SpellType.TELEPORT_SPELL);
        this.level = level;
        this.baseSpellPower = 10;
        this.spellPowerPerLevel = 10;
        this.baseManaCost = 20;
        this.manaCostPerLevel = 2;
        this.castTime = 0;
    }

    @Override
    public Optional<SoundEvent> getCastStartSound() {
        return Optional.empty();
    }

    @Override
    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of(SoundEvents.f_11852_);
    }

    @Override
    public void onCast(Level level, LivingEntity entity, PlayerMagicData playerMagicData) {
        Vec3 potentialTarget;
        IronsSpellbooks.LOGGER.debug("TeleportSpell.onCast isClient:{}, entity:{}, pmd:{}", new Object[]{level.f_46443_, entity, playerMagicData});
        TeleportData teleportData = (TeleportData)playerMagicData.getAdditionalCastData();
        Vec3 dest = null;
        if (teleportData != null && (potentialTarget = teleportData.getTeleportTargetPosition()) != null) {
            dest = potentialTarget;
        }
        if (dest == null) {
            dest = TeleportSpell.findTeleportLocation(level, entity, this.getDistance((Entity)entity));
        }
        Messages.sendToPlayersTrackingEntity(new ClientboundTeleportParticles(entity.m_20182_(), dest), (Entity)entity, true);
        if (entity.m_20159_()) {
            entity.m_8127_();
        }
        entity.m_6021_(dest.f_82479_, dest.f_82480_, dest.f_82481_);
        entity.m_183634_();
        playerMagicData.resetAdditionalCastData();
        entity.m_5496_(this.getCastFinishSound().get(), 2.0f, 1.0f);
        super.onCast(level, entity, playerMagicData);
    }

    public static Vec3 findTeleportLocation(Level level, LivingEntity entity, float maxDistance) {
        boolean los;
        IronsSpellbooks.LOGGER.debug("TeleportSpell.findTeleportLocation isClient:{}, entity:{}", (Object)level.f_46443_, (Object)entity);
        BlockHitResult blockHitResult = Utils.getTargetBlock(level, entity, ClipContext.Fluid.NONE, maxDistance);
        BlockPos pos = blockHitResult.m_82425_();
        Vec3 bbOffset = entity.m_20156_().m_82541_().m_82542_((double)(entity.m_20205_() / 3.0f), 0.0, (double)(entity.m_20206_() / 3.0f));
        Vec3 bbImpact = blockHitResult.m_82450_().m_82546_(bbOffset);
        int ledgeY = (int)level.m_45547_((ClipContext)new ClipContext((Vec3)Vec3.m_82539_((Vec3i)pos).m_82520_((double)0.0, (double)3.0, (double)0.0), (Vec3)Vec3.m_82539_((Vec3i)pos), (ClipContext.Block)ClipContext.Block.COLLIDER, (ClipContext.Fluid)ClipContext.Fluid.NONE, null)).m_82450_().f_82480_;
        Vec3 correctedPos = new Vec3((double)pos.m_123341_(), (double)ledgeY, (double)pos.m_123343_());
        boolean isAir = level.m_8055_(new BlockPos(correctedPos)).m_60795_();
        boolean bl = los = level.m_45547_(new ClipContext(bbImpact, bbImpact.m_82520_(0.0, (double)(ledgeY - pos.m_123342_()), 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity)).m_6662_() == HitResult.Type.MISS;
        if (isAir && los && Math.abs(ledgeY - pos.m_123342_()) <= 3) {
            return correctedPos.m_82520_(0.5, 0.076, 0.5);
        }
        return level.m_45547_(new ClipContext(bbImpact, bbImpact.m_82520_(0.0, (double)(-entity.m_20192_()), 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity)).m_82450_().m_82520_(0.0, 0.076, 0.0);
    }

    public static void particleCloud(Level level, Vec3 pos) {
        if (level.f_46443_) {
            double width = 0.5;
            float height = 1.0f;
            for (int i = 0; i < 55; ++i) {
                double x = pos.f_82479_ + level.f_46441_.nextDouble() * width * 2.0 - width;
                double y = pos.f_82480_ + (double)height + level.f_46441_.nextDouble() * (double)height * 1.2 * 2.0 - (double)height * 1.2;
                double z = pos.f_82481_ + level.f_46441_.nextDouble() * width * 2.0 - width;
                double dx = level.f_46441_.nextDouble() * 0.1 * (double)(level.f_46441_.nextBoolean() ? 1 : -1);
                double dy = level.f_46441_.nextDouble() * 0.1 * (double)(level.f_46441_.nextBoolean() ? 1 : -1);
                double dz = level.f_46441_.nextDouble() * 0.1 * (double)(level.f_46441_.nextBoolean() ? 1 : -1);
                level.m_6493_((ParticleOptions)ParticleTypes.f_123760_, true, x, y, z, dx, dy, dz);
            }
        }
    }

    private float getDistance(Entity sourceEntity) {
        return this.getSpellPower(sourceEntity);
    }

    @Override
    public List<MutableComponent> getUniqueInfo(LivingEntity caster) {
        return List.of(Component.translatable("ui.irons_spellbooks.distance", Utils.stringTruncation(this.getDistance((Entity)caster), 1)));
    }

    @Override
    public AnimationHolder getCastStartAnimation() {
        return AnimationHolder.none();
    }

    public static class TeleportData
    implements CastData {
        private Vec3 teleportTargetPosition;

        public TeleportData(Vec3 teleportTargetPosition) {
            this.teleportTargetPosition = teleportTargetPosition;
        }

        public void setTeleportTargetPosition(Vec3 targetPosition) {
            this.teleportTargetPosition = targetPosition;
        }

        public Vec3 getTeleportTargetPosition() {
            return this.teleportTargetPosition;
        }

        @Override
        public void reset() {
        }
    }
}

