/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.ender;

import io.redspace.ironsspellbooks.capabilities.magic.CastData;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.entity.spells.comet.Comet;
import io.redspace.ironsspellbooks.entity.spells.target_area.TargetedAreaEntity;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.DefaultConfig;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellRarity;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.spells.TargetAreaCastData;
import io.redspace.ironsspellbooks.util.AnimationHolder;
import io.redspace.ironsspellbooks.util.Component;
import io.redspace.ironsspellbooks.util.ParticleHelper;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class StarfallSpell
extends AbstractSpell {
    public static DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.UNCOMMON).setSchool(SchoolType.ENDER).setMaxLevel(10).setCooldownSeconds(16.0).build();

    public StarfallSpell() {
        this(1);
    }

    @Override
    public List<MutableComponent> getUniqueInfo(LivingEntity caster) {
        return List.of(Component.translatable("ui.irons_spellbooks.damage", Utils.stringTruncation(this.getDamage(caster), 1)), Component.translatable("ui.irons_spellbooks.radius", Utils.stringTruncation(this.getRadius(caster), 1)));
    }

    public StarfallSpell(int level) {
        super(SpellType.STARFALL_SPELL);
        this.setLevel(level);
        this.manaCostPerLevel = 1;
        this.baseSpellPower = 8;
        this.spellPowerPerLevel = 1;
        this.castTime = 160;
        this.baseManaCost = 5;
    }

    @Override
    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)SoundRegistry.ENDER_CAST.get());
    }

    @Override
    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.empty();
    }

    @Override
    public void onCast(Level world, LivingEntity entity, PlayerMagicData playerMagicData) {
        if (!(playerMagicData.getAdditionalCastData() instanceof TargetAreaCastData)) {
            Vec3 targetArea = Utils.moveToRelativeGroundLevel(world, Utils.raycastForEntity(world, (Entity)entity, 40.0f, true).m_82450_(), 12);
            playerMagicData.setAdditionalCastData(new TargetAreaCastData(targetArea, TargetedAreaEntity.createTargetAreaEntity(world, targetArea, this.getRadius(entity), 6291596)));
        }
        super.onCast(world, entity, playerMagicData);
    }

    @Override
    public void onServerCastTick(Level level, LivingEntity entity, @Nullable PlayerMagicData playerMagicData) {
        CastData castData;
        if (playerMagicData != null && (playerMagicData.getCastDurationRemaining() + 1) % 4 == 0 && (castData = playerMagicData.getAdditionalCastData()) instanceof TargetAreaCastData) {
            TargetAreaCastData targetAreaCastData = (TargetAreaCastData)castData;
            for (int i = 0; i < 2; ++i) {
                Vec3 center = targetAreaCastData.getCenter();
                float radius = this.getRadius(entity);
                Vec3 spawn = center.m_82549_(new Vec3(0.0, 0.0, (double)(entity.m_21187_().nextFloat() * radius)).m_82524_((float)entity.m_21187_().nextInt(360)));
                spawn = this.raiseWithCollision(spawn, 12, level);
                this.shootComet(level, entity, spawn);
                MagicManager.spawnParticles(level, ParticleHelper.COMET_FOG, spawn.f_82479_, spawn.f_82480_, spawn.f_82481_, 1, 1.0, 1.0, 1.0, 1.0, false);
                MagicManager.spawnParticles(level, ParticleHelper.COMET_FOG, spawn.f_82479_, spawn.f_82480_, spawn.f_82481_, 1, 1.0, 1.0, 1.0, 1.0, true);
            }
        }
    }

    @Override
    protected void playSound(Optional<SoundEvent> sound, Entity entity, boolean playDefaultSound) {
        super.playSound(sound, entity, false);
    }

    private Vec3 raiseWithCollision(Vec3 start, int blocks, Level level) {
        Vec3 raised;
        for (int i = 0; i < blocks && level.m_8055_(new BlockPos(raised = start.m_82520_(0.0, 1.0, 0.0))).m_60795_(); ++i) {
            start = raised;
        }
        return start;
    }

    private float getDamage(LivingEntity caster) {
        return this.getSpellPower((Entity)caster) * 0.5f;
    }

    private float getRadius(LivingEntity caster) {
        return 6.0f;
    }

    public void shootComet(Level world, LivingEntity entity, Vec3 spawn) {
        Comet fireball = new Comet(world, entity);
        fireball.m_146884_(spawn.m_82520_(-1.0, 0.0, 0.0));
        fireball.shoot(new Vec3((double)0.15f, (double)-0.85f, 0.0), 0.075f);
        fireball.setDamage(this.getDamage(entity));
        fireball.setExplosionRadius(2.0f);
        world.m_7967_((Entity)fireball);
        world.m_6263_(null, spawn.f_82479_, spawn.f_82480_, spawn.f_82481_, SoundEvents.f_11932_, SoundSource.PLAYERS, 3.0f, 0.7f + world.f_46441_.nextFloat() * 0.3f);
    }

    @Override
    public AnimationHolder getCastStartAnimation() {
        return ANIMATION_CONTINUOUS_OVERHEAD;
    }
}

