/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.ender;

import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.entity.mobs.AntiMagicSusceptible;
import io.redspace.ironsspellbooks.entity.mobs.MagicSummon;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.DefaultConfig;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellRarity;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.LazyOptional;

public class CounterspellSpell
extends AbstractSpell {
    public static final LazyOptional<List<MobEffect>> LAZY_MAGICAL_EFFECTS = LazyOptional.of(() -> List.of((MobEffect)MobEffectRegistry.ABYSSAL_SHROUD.get(), (MobEffect)MobEffectRegistry.ASCENSION.get(), (MobEffect)MobEffectRegistry.ANGEL_WINGS.get(), (MobEffect)MobEffectRegistry.CHARGED.get(), (MobEffect)MobEffectRegistry.EVASION.get(), (MobEffect)MobEffectRegistry.HEARTSTOP.get(), (MobEffect)MobEffectRegistry.FORTIFY.get(), (MobEffect)MobEffectRegistry.TRUE_INVISIBILITY.get(), (MobEffect)MobEffectRegistry.FORTIFY.get(), (MobEffect)MobEffectRegistry.REND.get(), (MobEffect)MobEffectRegistry.SPIDER_ASPECT.get(), (MobEffect)MobEffectRegistry.BLIGHT.get()));
    public static DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchool(SchoolType.ENDER).setMaxLevel(1).setCooldownSeconds(15.0).build();

    public CounterspellSpell() {
        this(1);
    }

    public CounterspellSpell(int level) {
        super(SpellType.COUNTERSPELL_SPELL);
        this.level = level;
        this.manaCostPerLevel = 1;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 1;
        this.castTime = 0;
        this.baseManaCost = 50;
    }

    @Override
    public Optional<SoundEvent> getCastStartSound() {
        return Optional.empty();
    }

    @Override
    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.empty();
    }

    @Override
    public void onCast(Level world, LivingEntity entity, PlayerMagicData playerMagicData) {
        Vec3 start = entity.m_146892_();
        Vec3 end = start.m_82549_(entity.m_20156_().m_82541_().m_82490_(80.0));
        HitResult hitResult = Utils.raycastForEntity(entity.f_19853_, (Entity)entity, start, end, true, 0.35f, Utils::validAntiMagicTarget);
        Vec3 forward = entity.m_20156_().m_82541_();
        if (hitResult instanceof EntityHitResult) {
            MagicSummon summon;
            AntiMagicSusceptible antiMagicSusceptible;
            EntityHitResult entityHitResult = (EntityHitResult)hitResult;
            double distance = entity.m_20270_(entityHitResult.m_82443_());
            float i = 1.0f;
            while ((double)i < distance) {
                Vec3 pos = entity.m_146892_().m_82549_(forward.m_82490_((double)i));
                MagicManager.spawnParticles(world, (ParticleOptions)ParticleTypes.f_123809_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0, false);
                i += 0.5f;
            }
            Entity entity2 = entityHitResult.m_82443_();
            if (entity2 instanceof AntiMagicSusceptible && (!((antiMagicSusceptible = (AntiMagicSusceptible)entity2) instanceof MagicSummon) || (summon = (MagicSummon)antiMagicSusceptible).getSummoner() != entity)) {
                antiMagicSusceptible.onAntiMagic(playerMagicData);
            } else {
                entity2 = entityHitResult.m_82443_();
                if (entity2 instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)entity2;
                    Utils.serverSideCancelCast(serverPlayer, true);
                } else {
                    entity2 = entityHitResult.m_82443_();
                    if (entity2 instanceof AbstractSpellCastingMob) {
                        AbstractSpellCastingMob abstractSpellCastingMob = (AbstractSpellCastingMob)entity2;
                        abstractSpellCastingMob.cancelCast();
                    }
                }
            }
            Entity entity3 = entityHitResult.m_82443_();
            if (entity3 instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity3;
                for (MobEffect mobEffect : (List)LAZY_MAGICAL_EFFECTS.resolve().get()) {
                    livingEntity.m_21195_(mobEffect);
                }
            }
        } else {
            for (float i = 1.0f; i < 40.0f; i += 0.5f) {
                Vec3 pos = entity.m_146892_().m_82549_(forward.m_82490_((double)i));
                MagicManager.spawnParticles(world, (ParticleOptions)ParticleTypes.f_123809_, pos.f_82479_, pos.f_82480_, pos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0, false);
                if (world.m_8055_(new BlockPos(pos)).m_60795_()) {
                    continue;
                }
                break;
            }
        }
        super.onCast(world, entity, playerMagicData);
    }
}

