/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.blood;

import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import io.redspace.ironsspellbooks.network.spell.ClientboundBloodSiphonParticles;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.setup.Messages;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.DefaultConfig;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellRarity;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.Component;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class RayOfSiphoningSpell
extends AbstractSpell {
    public static DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.COMMON).setSchool(SchoolType.BLOOD).setMaxLevel(10).setCooldownSeconds(15.0).build();

    public RayOfSiphoningSpell() {
        this(1);
    }

    @Override
    public List<MutableComponent> getUniqueInfo(LivingEntity caster) {
        return List.of(Component.translatable("ui.irons_spellbooks.damage", Utils.stringTruncation(this.getTickDamage((Entity)caster), 1)), Component.translatable("ui.irons_spellbooks.distance", Utils.stringTruncation(RayOfSiphoningSpell.getRange(this.level), 1)));
    }

    public RayOfSiphoningSpell(int level) {
        super(SpellType.RAY_OF_SIPHONING_SPELL);
        this.level = level;
        this.manaCostPerLevel = 1;
        this.baseSpellPower = 4;
        this.spellPowerPerLevel = 1;
        this.castTime = 100;
        this.baseManaCost = 8;
    }

    @Override
    public Optional<SoundEvent> getCastStartSound() {
        return Optional.empty();
    }

    @Override
    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)SoundRegistry.RAY_OF_SIPHONING.get());
    }

    @Override
    public void onCast(Level level, LivingEntity entity, PlayerMagicData playerMagicData) {
        Entity target;
        HitResult hitResult = Utils.raycastForEntity(level, (Entity)entity, RayOfSiphoningSpell.getRange(this.level), true, 0.15f);
        if (hitResult.m_6662_() == HitResult.Type.ENTITY && (target = ((EntityHitResult)hitResult).m_82443_()) instanceof LivingEntity && DamageSources.applyDamage(target, this.getTickDamage((Entity)entity), this.getSpellType().getDamageSource((Entity)entity), SchoolType.BLOOD)) {
            entity.m_5634_(this.getTickDamage((Entity)entity));
            Messages.sendToPlayersTrackingEntity(new ClientboundBloodSiphonParticles(target.m_20182_().m_82520_(0.0, (double)(target.m_20206_() / 2.0f), 0.0), entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0)), (Entity)entity, true);
        }
        super.onCast(level, entity, playerMagicData);
    }

    public static float getRange(int level) {
        return 12.0f;
    }

    private float getTickDamage(Entity caster) {
        return this.getSpellPower(caster) * 0.25f;
    }

    @Override
    public boolean shouldAIStopCasting(AbstractSpellCastingMob mob, LivingEntity target) {
        return mob.m_20280_((Entity)target) > (double)(RayOfSiphoningSpell.getRange(this.level) * RayOfSiphoningSpell.getRange(this.level)) * 1.2;
    }
}

