/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.blood;

import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.entity.mobs.MagicSummon;
import io.redspace.ironsspellbooks.entity.mobs.SummonedSkeleton;
import io.redspace.ironsspellbooks.entity.mobs.SummonedZombie;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.DefaultConfig;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellRarity;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.Component;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;

public class RaiseDeadSpell
extends AbstractSpell {
    public static DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.UNCOMMON).setSchool(SchoolType.BLOOD).setMaxLevel(6).setCooldownSeconds(150.0).build();

    public RaiseDeadSpell() {
        this(1);
    }

    @Override
    public List<MutableComponent> getUniqueInfo(LivingEntity caster) {
        return List.of(Component.translatable("ui.irons_spellbooks.summon_count", this.level));
    }

    public RaiseDeadSpell(int level) {
        super(SpellType.RAISE_DEAD_SPELL);
        this.level = level;
        this.manaCostPerLevel = 10;
        this.baseSpellPower = 10;
        this.spellPowerPerLevel = 3;
        this.castTime = 30;
        this.baseManaCost = 50;
    }

    @Override
    public Optional<SoundEvent> getCastStartSound() {
        return Optional.of((SoundEvent)SoundRegistry.RAISE_DEAD_START.get());
    }

    @Override
    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)SoundRegistry.RAISE_DEAD_FINISH.get());
    }

    @Override
    public void onCast(Level world, LivingEntity entity, PlayerMagicData playerMagicData) {
        int summonTime = 12000;
        for (int i = 0; i < this.level; ++i) {
            boolean isSkeleton = world.f_46441_.nextDouble() < 0.3;
            ItemStack[] equipment = this.getEquipment(this.getSpellPower((Entity)entity), world.m_5822_());
            MagicSummon undead = isSkeleton ? new SummonedSkeleton(world, entity, true) : new SummonedZombie(world, entity, true);
            undead.m_6518_((ServerLevelAccessor)((ServerLevel)world), world.m_6436_(undead.m_20097_()), MobSpawnType.MOB_SUMMONED, null, null);
            undead.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.RAISE_DEAD_TIMER.get(), summonTime, 0, false, false, false));
            this.equip((Mob)undead, equipment);
            Vec3 spawn = entity.m_20182_();
            for (int j = 0; j < 4; ++j) {
                float distance = (float)this.level / 4.0f + 1.0f;
                spawn = entity.m_146892_().m_82549_(new Vec3(0.0, 0.0, (double)(distance *= (float)(3 - j) / 3.0f)).m_82524_(6.281f / (float)this.level * (float)i));
                if (!world.m_8055_(new BlockPos(spawn = new Vec3(spawn.f_82479_, (double)Utils.findRelativeGroundLevel(world, spawn, 5), spawn.f_82481_)).m_7495_()).m_60795_()) break;
            }
            undead.m_7678_(spawn.f_82479_, spawn.f_82480_, spawn.f_82481_, entity.m_146908_(), 0.0f);
            world.m_7967_((Entity)undead);
        }
        int effectAmplifier = this.level - 1;
        if (entity.m_21023_((MobEffect)MobEffectRegistry.RAISE_DEAD_TIMER.get())) {
            effectAmplifier += entity.m_21124_((MobEffect)MobEffectRegistry.RAISE_DEAD_TIMER.get()).m_19564_() + 1;
        }
        entity.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.RAISE_DEAD_TIMER.get(), summonTime, effectAmplifier, false, false, true));
        super.onCast(world, entity, playerMagicData);
    }

    private void equip(Mob mob, ItemStack[] equipment) {
        mob.m_8061_(EquipmentSlot.FEET, equipment[0]);
        mob.m_8061_(EquipmentSlot.LEGS, equipment[1]);
        mob.m_8061_(EquipmentSlot.CHEST, equipment[2]);
        mob.m_8061_(EquipmentSlot.HEAD, equipment[3]);
        mob.m_21409_(EquipmentSlot.FEET, 0.0f);
        mob.m_21409_(EquipmentSlot.LEGS, 0.0f);
        mob.m_21409_(EquipmentSlot.CHEST, 0.0f);
        mob.m_21409_(EquipmentSlot.HEAD, 0.0f);
    }

    private ItemStack[] getEquipment(float power, Random random) {
        Item[] leather = new Item[]{Items.f_42463_, Items.f_42462_, Items.f_42408_, Items.f_42407_};
        Item[] chain = new Item[]{Items.f_42467_, Items.f_42466_, Items.f_42465_, Items.f_42464_};
        Item[] iron = new Item[]{Items.f_42471_, Items.f_42470_, Items.f_42469_, Items.f_42468_};
        int minQuality = 12;
        int maxQuality = SpellType.RAISE_DEAD_SPELL.getMaxLevel() * this.spellPowerPerLevel + 15;
        ItemStack[] result = new ItemStack[4];
        for (int i = 0; i < 4; ++i) {
            float quality = Mth.m_14036_((float)((power + (float)Mth.m_144928_((Random)random, (int)-3, (int)8) - (float)minQuality) / (float)(maxQuality - minQuality)), (float)0.0f, (float)0.95f);
            if (random.nextDouble() < (double)(quality * quality)) {
                if ((double)quality > 0.85) {
                    result[i] = new ItemStack((ItemLike)iron[i]);
                    continue;
                }
                if ((double)quality > 0.65) {
                    result[i] = new ItemStack((ItemLike)chain[i]);
                    continue;
                }
                if ((double)quality > 0.15) {
                    result[i] = new ItemStack((ItemLike)leather[i]);
                    continue;
                }
                result[i] = ItemStack.f_41583_;
                continue;
            }
            result[i] = ItemStack.f_41583_;
        }
        return result;
    }
}

