/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.blood;

import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.DefaultConfig;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellRarity;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.spells.ender.TeleportSpell;
import io.redspace.ironsspellbooks.util.AnimationHolder;
import io.redspace.ironsspellbooks.util.Component;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.List;
import java.util.Optional;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BloodStepSpell
extends AbstractSpell {
    public static DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.UNCOMMON).setSchool(SchoolType.BLOOD).setMaxLevel(5).setCooldownSeconds(5.0).build();

    public BloodStepSpell() {
        this(1);
    }

    @Override
    public List<MutableComponent> getUniqueInfo(LivingEntity caster) {
        return List.of(Component.translatable("ui.irons_spellbooks.distance", Utils.stringTruncation(this.getDistance((Entity)caster), 1)));
    }

    public BloodStepSpell(int level) {
        super(SpellType.BLOOD_STEP_SPELL);
        this.level = level;
        this.baseSpellPower = 12;
        this.spellPowerPerLevel = 4;
        this.baseManaCost = 30;
        this.manaCostPerLevel = 10;
        this.castTime = 0;
    }

    @Override
    public Optional<SoundEvent> getCastStartSound() {
        return Optional.empty();
    }

    @Override
    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)SoundRegistry.BLOOD_STEP.get());
    }

    @Override
    public void onClientPreCast(Level level, LivingEntity entity, InteractionHand hand, @Nullable PlayerMagicData playerMagicData) {
        super.onClientPreCast(level, entity, hand, playerMagicData);
        Vec3 forward = entity.m_20156_().m_82541_();
        for (int i = 0; i < 35; ++i) {
            Vec3 motion = forward.m_82490_(level.f_46441_.nextDouble() * 0.25);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123777_, entity.m_20208_((double)0.4f), entity.m_20187_(), entity.m_20262_((double)0.4f), motion.f_82479_, motion.f_82480_, motion.f_82481_);
        }
    }

    @Override
    public void onCast(Level level, LivingEntity entity, PlayerMagicData playerMagicData) {
        Vec3 dest = null;
        TeleportSpell.TeleportData teleportData = (TeleportSpell.TeleportData)playerMagicData.getAdditionalCastData();
        if (teleportData != null) {
            Vec3 potentialTarget = teleportData.getTeleportTargetPosition();
            if (potentialTarget != null) {
                dest = potentialTarget;
                entity.m_6021_(dest.f_82479_, dest.f_82480_, dest.f_82481_);
            }
        } else {
            Entity entity2;
            HitResult hitResult = Utils.raycastForEntity(level, (Entity)entity, this.getDistance((Entity)entity), true);
            if (entity.m_20159_()) {
                entity.m_8127_();
            }
            if (hitResult.m_6662_() == HitResult.Type.ENTITY && (entity2 = ((EntityHitResult)hitResult).m_82443_()) instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)entity2;
                for (int i = 0; i < 8 && !level.m_8055_(new BlockPos(dest = target.m_20182_().m_82546_(new Vec3(0.0, 0.0, 1.5).m_82524_(-(target.m_146908_() + (float)(i * 45)) * ((float)Math.PI / 180)))).m_7494_()).m_60795_(); ++i) {
                }
                entity.m_6021_(dest.f_82479_, dest.f_82480_ + 1.0, dest.f_82481_);
                entity.m_7618_(EntityAnchorArgument.Anchor.EYES, target.m_146892_().m_82492_(0.0, 0.15, 0.0));
            } else {
                dest = TeleportSpell.findTeleportLocation(level, entity, this.getDistance((Entity)entity));
                entity.m_6021_(dest.f_82479_, dest.f_82480_, dest.f_82481_);
            }
        }
        entity.m_183634_();
        level.m_6263_(null, dest.f_82479_, dest.f_82480_, dest.f_82481_, this.getCastFinishSound().get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
        entity.m_6842_(true);
        entity.m_7292_(new MobEffectInstance((MobEffect)MobEffectRegistry.TRUE_INVISIBILITY.get(), 100, 0, false, false, true));
        super.onCast(level, entity, playerMagicData);
    }

    private float getDistance(Entity sourceEntity) {
        return this.getSpellPower(sourceEntity);
    }

    @Override
    public AnimationHolder getCastStartAnimation() {
        return AnimationHolder.none();
    }
}

