/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.blood;

import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.entity.spells.blood_needle.BloodNeedle;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.DefaultConfig;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellRarity;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.Component;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class BloodNeedlesSpell
extends AbstractSpell {
    public static DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.UNCOMMON).setSchool(SchoolType.BLOOD).setMaxLevel(10).setCooldownSeconds(10.0).build();

    public BloodNeedlesSpell() {
        this(1);
    }

    @Override
    public List<MutableComponent> getUniqueInfo(LivingEntity caster) {
        return List.of(Component.translatable("ui.irons_spellbooks.damage", Utils.stringTruncation(this.getDamage(caster), 2)), Component.translatable("ui.irons_spellbooks.projectile_count", this.getCount()));
    }

    public BloodNeedlesSpell(int level) {
        super(SpellType.BlOOD_NEEDLES_SPELL);
        this.level = level;
        this.manaCostPerLevel = 5;
        this.baseSpellPower = 8;
        this.spellPowerPerLevel = 1;
        this.castTime = 0;
        this.baseManaCost = 25;
    }

    @Override
    public Optional<SoundEvent> getCastStartSound() {
        return Optional.empty();
    }

    @Override
    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.empty();
    }

    @Override
    public void onCast(Level world, LivingEntity entity, PlayerMagicData playerMagicData) {
        int count = this.getCount();
        float damage = this.getDamage(entity);
        int degreesPerNeedle = 360 / count;
        HitResult raycast = Utils.raycastForEntity(world, (Entity)entity, 32.0f, true);
        for (int i = 0; i < count; ++i) {
            BloodNeedle needle = new BloodNeedle(world, entity);
            int rotation = degreesPerNeedle * i - degreesPerNeedle / 2;
            needle.setDamage(damage);
            needle.setZRot(rotation);
            Vec3 spawn = entity.m_146892_().m_82549_(new Vec3(0.0, 1.5, 0.0).m_82535_((float)rotation * ((float)Math.PI / 180)).m_82496_(-entity.m_146909_() * ((float)Math.PI / 180)).m_82524_(-entity.m_146908_() * ((float)Math.PI / 180)));
            needle.m_20219_(spawn);
            needle.shoot(raycast.m_82450_().m_82546_(spawn).m_82541_());
            world.m_7967_((Entity)needle);
        }
        super.onCast(world, entity, playerMagicData);
    }

    private int getCount() {
        return 5;
    }

    private float getDamage(LivingEntity caster) {
        return this.getSpellPower((Entity)caster) * 0.25f;
    }
}

