/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells.blood;

import io.redspace.ironsspellbooks.capabilities.magic.CastData;
import io.redspace.ironsspellbooks.capabilities.magic.CastTargetingData;
import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.entity.spells.blood_needle.BloodNeedle;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.DefaultConfig;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellRarity;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.Component;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class AcupunctureSpell
extends AbstractSpell {
    public static DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.RARE).setSchool(SchoolType.BLOOD).setMaxLevel(10).setCooldownSeconds(20.0).build();

    public AcupunctureSpell() {
        this(1);
    }

    @Override
    public List<MutableComponent> getUniqueInfo(LivingEntity caster) {
        return List.of(Component.translatable("ui.irons_spellbooks.damage", Utils.stringTruncation(this.getDamage(caster), 2)), Component.translatable("ui.irons_spellbooks.projectile_count", this.getCount(caster)));
    }

    public AcupunctureSpell(int level) {
        super(SpellType.ACUPUNCTURE_SPELL);
        this.level = level;
        this.manaCostPerLevel = 5;
        this.baseSpellPower = 1;
        this.spellPowerPerLevel = 0;
        this.castTime = 0;
        this.baseManaCost = 25;
    }

    @Override
    public Optional<SoundEvent> getCastStartSound() {
        return Optional.empty();
    }

    @Override
    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.empty();
    }

    @Override
    public boolean checkPreCastConditions(Level level, LivingEntity entity, PlayerMagicData playerMagicData) {
        return Utils.preCastTargetHelper(level, entity, playerMagicData, this.getSpellType(), 32, 0.15f);
    }

    @Override
    public void onCast(Level world, LivingEntity entity, PlayerMagicData playerMagicData) {
        CastTargetingData targetData;
        LivingEntity targetEntity;
        CastData castData = playerMagicData.getAdditionalCastData();
        if (castData instanceof CastTargetingData && (targetEntity = (targetData = (CastTargetingData)castData).getTarget((ServerLevel)world)) != null) {
            int count = this.getCount(entity);
            float damage = this.getDamage(entity);
            Vec3 center = targetEntity.m_20182_().m_82520_(0.0, (double)(targetEntity.m_20192_() / 2.0f), 0.0);
            float degreesPerNeedle = 360.0f / (float)count;
            for (int i = 0; i < count; ++i) {
                Vec3 offset = new Vec3(0.0, Math.random(), 0.55).m_82541_().m_82490_((double)(targetEntity.m_20205_() + 2.75f)).m_82524_(degreesPerNeedle * (float)i * ((float)Math.PI / 180));
                Vec3 spawn = center.m_82549_(offset);
                Vec3 motion = center.m_82546_(spawn).m_82541_();
                BloodNeedle needle = new BloodNeedle(world, entity);
                needle.m_20219_(spawn);
                needle.shoot(motion.m_82490_((double)0.35f));
                needle.setDamage(damage);
                needle.setScale(0.4f);
                world.m_7967_((Entity)needle);
            }
        }
        super.onCast(world, entity, playerMagicData);
    }

    private int getCount(LivingEntity caster) {
        return (int)((float)(4 + this.level) * this.getSpellPower((Entity)caster));
    }

    private float getDamage(LivingEntity caster) {
        return 1.0f + this.getSpellPower((Entity)caster);
    }
}

