/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells;

import com.google.common.util.concurrent.AtomicDouble;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.damage.DamageSources;
import io.redspace.ironsspellbooks.spells.AbstractSpell;
import io.redspace.ironsspellbooks.spells.CastType;
import io.redspace.ironsspellbooks.spells.NoneSpell;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellRarity;
import io.redspace.ironsspellbooks.spells.blood.AcupunctureSpell;
import io.redspace.ironsspellbooks.spells.blood.BloodNeedlesSpell;
import io.redspace.ironsspellbooks.spells.blood.BloodSlashSpell;
import io.redspace.ironsspellbooks.spells.blood.BloodStepSpell;
import io.redspace.ironsspellbooks.spells.blood.HeartstopSpell;
import io.redspace.ironsspellbooks.spells.blood.RaiseDeadSpell;
import io.redspace.ironsspellbooks.spells.blood.RayOfSiphoningSpell;
import io.redspace.ironsspellbooks.spells.blood.WitherSkullSpell;
import io.redspace.ironsspellbooks.spells.ender.CounterspellSpell;
import io.redspace.ironsspellbooks.spells.ender.DragonBreathSpell;
import io.redspace.ironsspellbooks.spells.ender.EvasionSpell;
import io.redspace.ironsspellbooks.spells.ender.MagicArrowSpell;
import io.redspace.ironsspellbooks.spells.ender.MagicMissileSpell;
import io.redspace.ironsspellbooks.spells.ender.StarfallSpell;
import io.redspace.ironsspellbooks.spells.ender.TeleportSpell;
import io.redspace.ironsspellbooks.spells.evocation.ChainCreeperSpell;
import io.redspace.ironsspellbooks.spells.evocation.FangStrikeSpell;
import io.redspace.ironsspellbooks.spells.evocation.FangWardSpell;
import io.redspace.ironsspellbooks.spells.evocation.FirecrackerSpell;
import io.redspace.ironsspellbooks.spells.evocation.InvisibilitySpell;
import io.redspace.ironsspellbooks.spells.evocation.LobCreeperSpell;
import io.redspace.ironsspellbooks.spells.evocation.ShieldSpell;
import io.redspace.ironsspellbooks.spells.evocation.SpectralHammerSpell;
import io.redspace.ironsspellbooks.spells.evocation.SummonHorseSpell;
import io.redspace.ironsspellbooks.spells.evocation.SummonVexSpell;
import io.redspace.ironsspellbooks.spells.fire.BlazeStormSpell;
import io.redspace.ironsspellbooks.spells.fire.BurningDashSpell;
import io.redspace.ironsspellbooks.spells.fire.FireBombSpell;
import io.redspace.ironsspellbooks.spells.fire.FireBreathSpell;
import io.redspace.ironsspellbooks.spells.fire.FireballSpell;
import io.redspace.ironsspellbooks.spells.fire.FireboltSpell;
import io.redspace.ironsspellbooks.spells.fire.WallOfFireSpell;
import io.redspace.ironsspellbooks.spells.holy.AngelWingsSpell;
import io.redspace.ironsspellbooks.spells.holy.BlessingOfLifeSpell;
import io.redspace.ironsspellbooks.spells.holy.CloudOfRegenerationSpell;
import io.redspace.ironsspellbooks.spells.holy.FortifySpell;
import io.redspace.ironsspellbooks.spells.holy.GreaterHealSpell;
import io.redspace.ironsspellbooks.spells.holy.HealSpell;
import io.redspace.ironsspellbooks.spells.holy.HealingCircleSpell;
import io.redspace.ironsspellbooks.spells.holy.WispSpell;
import io.redspace.ironsspellbooks.spells.ice.ConeOfColdSpell;
import io.redspace.ironsspellbooks.spells.ice.FrostStepSpell;
import io.redspace.ironsspellbooks.spells.ice.FrostbiteSpell;
import io.redspace.ironsspellbooks.spells.ice.IceBlockSpell;
import io.redspace.ironsspellbooks.spells.ice.IcicleSpell;
import io.redspace.ironsspellbooks.spells.ice.SummonPolarBearSpell;
import io.redspace.ironsspellbooks.spells.lightning.AscensionSpell;
import io.redspace.ironsspellbooks.spells.lightning.ChargeSpell;
import io.redspace.ironsspellbooks.spells.lightning.ElectrocuteSpell;
import io.redspace.ironsspellbooks.spells.lightning.LightningBoltSpell;
import io.redspace.ironsspellbooks.spells.lightning.LightningLanceSpell;
import io.redspace.ironsspellbooks.spells.poison.AcidOrbSpell;
import io.redspace.ironsspellbooks.spells.poison.BlightSpell;
import io.redspace.ironsspellbooks.spells.poison.PoisonArrowSpell;
import io.redspace.ironsspellbooks.spells.poison.PoisonBreathSpell;
import io.redspace.ironsspellbooks.spells.poison.PoisonSplashSpell;
import io.redspace.ironsspellbooks.spells.poison.RootSpell;
import io.redspace.ironsspellbooks.spells.poison.SpiderAspectSpell;
import io.redspace.ironsspellbooks.spells.void_school.AbyssalShroudSpell;
import io.redspace.ironsspellbooks.spells.void_school.BlackHoleSpell;
import io.redspace.ironsspellbooks.spells.void_school.VoidTentaclesSpell;
import io.redspace.ironsspellbooks.util.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.UseAnim;

public enum SpellType {
    NONE_SPELL(0, NoneSpell::new),
    FIREBALL_SPELL(1, FireballSpell::new),
    BURNING_DASH_SPELL(2, BurningDashSpell::new),
    TELEPORT_SPELL(3, TeleportSpell::new),
    MAGIC_MISSILE_SPELL(4, MagicMissileSpell::new),
    ELECTROCUTE_SPELL(5, ElectrocuteSpell::new),
    CONE_OF_COLD_SPELL(6, ConeOfColdSpell::new),
    HEAL_SPELL(7, HealSpell::new),
    BLOOD_SLASH_SPELL(8, BloodSlashSpell::new),
    SUMMON_VEX_SPELL(9, SummonVexSpell::new),
    FIREBOLT_SPELL(10, FireboltSpell::new),
    FIRE_BREATH_SPELL(11, FireBreathSpell::new),
    ICICLE_SPELL(12, IcicleSpell::new),
    FIRECRACKER_SPELL(13, FirecrackerSpell::new),
    SUMMON_HORSE_SPELL(14, SummonHorseSpell::new),
    ANGEL_WING_SPELL(15, AngelWingsSpell::new),
    SHIELD_SPELL(16, ShieldSpell::new),
    WALL_OF_FIRE_SPELL(17, WallOfFireSpell::new),
    WISP_SPELL(18, WispSpell::new),
    FANG_STRIKE_SPELL(19, FangStrikeSpell::new),
    FANG_WARD_SPELL(20, FangWardSpell::new),
    EVASION_SPELL(21, EvasionSpell::new),
    HEARTSTOP_SPELL(22, HeartstopSpell::new),
    LIGHTNING_LANCE_SPELL(23, LightningLanceSpell::new),
    LIGHTNING_BOLT_SPELL(24, LightningBoltSpell::new),
    RAISE_DEAD_SPELL(25, RaiseDeadSpell::new),
    WITHER_SKULL_SPELL(26, WitherSkullSpell::new),
    GREATER_HEAL_SPELL(27, GreaterHealSpell::new),
    CLOUD_OF_REGENERATION_SPELL(28, CloudOfRegenerationSpell::new),
    RAY_OF_SIPHONING_SPELL(29, RayOfSiphoningSpell::new),
    MAGIC_ARROW_SPELL(30, MagicArrowSpell::new),
    LOB_CREEPER_SPELL(31, LobCreeperSpell::new),
    CHAIN_CREEPER_SPELL(32, ChainCreeperSpell::new),
    BLAZE_STORM_SPELL(33, BlazeStormSpell::new),
    FROST_STEP_SPELL(34, FrostStepSpell::new),
    ABYSSAL_SHROUD_SPELL(35, AbyssalShroudSpell::new),
    FROSTBITE_SPELL(36, FrostbiteSpell::new),
    ASCENSION_SPELL(37, AscensionSpell::new),
    INVISIBILITY_SPELL(38, InvisibilitySpell::new),
    BLOOD_STEP_SPELL(39, BloodStepSpell::new),
    SUMMON_POLAR_BEAR_SPELL(40, SummonPolarBearSpell::new),
    BLESSING_OF_LIFE_SPELL(41, BlessingOfLifeSpell::new),
    DRAGON_BREATH_SPELL(42, DragonBreathSpell::new),
    FORTIFY_SPELL(43, FortifySpell::new),
    COUNTERSPELL_SPELL(44, CounterspellSpell::new),
    SPECTRAL_HAMMER_SPELL(45, SpectralHammerSpell::new),
    CHARGE_SPELL(46, ChargeSpell::new),
    VOID_TENTACLES_SPELL(47, VoidTentaclesSpell::new),
    ICE_BLOCK_SPELL(48, IceBlockSpell::new),
    POISON_BREATH_SPELL(49, PoisonBreathSpell::new),
    POISON_ARROW_SPELL(50, PoisonArrowSpell::new),
    POISON_SPLASH_SPELL(51, PoisonSplashSpell::new),
    ACID_ORB_SPELL(52, AcidOrbSpell::new),
    SPIDER_ASPECT_SPELL(53, SpiderAspectSpell::new),
    BLIGHT_SPELL(54, BlightSpell::new),
    ROOT_SPELL(55, RootSpell::new),
    BLACK_HOLE_SPELL(56, BlackHoleSpell::new),
    BlOOD_NEEDLES_SPELL(57, BloodNeedlesSpell::new),
    ACUPUNCTURE_SPELL(58, AcupunctureSpell::new),
    FIRE_BOMB_SPELL(59, FireBombSpell::new),
    STARFALL_SPELL(60, StarfallSpell::new),
    HEALING_CIRCLE_SPELL(61, HealingCircleSpell::new);

    private final int value;
    private final int maxRarity;
    private final GetSpellForType getSpellForType;
    private volatile List<Double> rarityWeights;
    private static final HashMap<SchoolType, List<SpellType>> spellsForSchool;

    private SpellType(int newValue, GetSpellForType getter) {
        this.value = newValue;
        this.maxRarity = SpellRarity.LEGENDARY.getValue();
        this.getSpellForType = getter;
    }

    public int getValue() {
        return this.value;
    }

    public int getMinRarity() {
        return ServerConfigs.getSpellConfig(this).minRarity().getValue();
    }

    public int getMaxRarity() {
        return this.maxRarity;
    }

    public int getMinLevel() {
        return 1;
    }

    public int getMaxLevel() {
        return ServerConfigs.getSpellConfig(this).maxLevel();
    }

    public static SpellType getTypeFromValue(int value) {
        return SpellType.values()[value];
    }

    public CastType getCastType() {
        return switch (this) {
            case FIREBALL_SPELL, WISP_SPELL, FANG_STRIKE_SPELL, FANG_WARD_SPELL, SUMMON_VEX_SPELL, RAISE_DEAD_SPELL, GREATER_HEAL_SPELL, CHAIN_CREEPER_SPELL, INVISIBILITY_SPELL, SUMMON_POLAR_BEAR_SPELL, BLESSING_OF_LIFE_SPELL, FORTIFY_SPELL, VOID_TENTACLES_SPELL, SUMMON_HORSE_SPELL, ICE_BLOCK_SPELL, POISON_SPLASH_SPELL, BLIGHT_SPELL, ROOT_SPELL, HEALING_CIRCLE_SPELL -> CastType.LONG;
            case ELECTROCUTE_SPELL, CONE_OF_COLD_SPELL, FIRE_BREATH_SPELL, WALL_OF_FIRE_SPELL, CLOUD_OF_REGENERATION_SPELL, RAY_OF_SIPHONING_SPELL, BLAZE_STORM_SPELL, DRAGON_BREATH_SPELL, POISON_BREATH_SPELL, STARFALL_SPELL -> CastType.CONTINUOUS;
            case LIGHTNING_LANCE_SPELL, MAGIC_ARROW_SPELL, POISON_ARROW_SPELL, ACID_ORB_SPELL, BLACK_HOLE_SPELL, FIRE_BOMB_SPELL -> CastType.CHARGE;
            default -> CastType.INSTANT;
        };
    }

    public UseAnim getUseAnim() {
        return switch (this) {
            case LIGHTNING_LANCE_SPELL -> UseAnim.SPEAR;
            default -> UseAnim.BOW;
        };
    }

    public AbstractSpell getSpellForType(int level) {
        return this.getSpellForType.get(level);
    }

    public static float getRarityMapped(float levelMin, float levelMax, float rarityMin, float rarityMax, float levelToMap) {
        return rarityMin + (levelToMap - levelMin) * (rarityMax - rarityMin) / (levelMax - levelMin);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeRarityWeights() {
        SpellType spellType = NONE_SPELL;
        synchronized (spellType) {
            if (this.rarityWeights == null) {
                int minRarity = this.getMinRarity();
                int maxRarity = this.getMaxRarity();
                List<Double> rarityRawConfig = SpellRarity.getRawRarityConfig();
                List<Double> rarityConfig = SpellRarity.getRarityConfig();
                if (minRarity != 0) {
                    List<Double> subList = rarityRawConfig.subList(minRarity, maxRarity + 1);
                    double subtotal = subList.stream().reduce(0.0, Double::sum);
                    List<Double> rarityRawWeights = subList.stream().map(item -> item / subtotal * (1.0 - subtotal) + item).toList();
                    AtomicDouble counter = new AtomicDouble();
                    this.rarityWeights = new ArrayList<Double>();
                    rarityRawWeights.forEach(item -> this.rarityWeights.add(counter.addAndGet(item.doubleValue())));
                } else {
                    this.rarityWeights = rarityConfig;
                }
            }
        }
    }

    public SpellRarity getRarity(int level) {
        if (this.rarityWeights == null) {
            this.initializeRarityWeights();
        }
        int maxLevel = this.getMaxLevel();
        int maxRarity = this.getMaxRarity();
        if (maxLevel == 1) {
            return SpellRarity.values()[this.getMinRarity()];
        }
        double percentOfMaxLevel = (double)level / (double)maxLevel;
        int lookupOffset = maxRarity + 1 - this.rarityWeights.size();
        for (int i = 0; i < this.rarityWeights.size(); ++i) {
            if (!(percentOfMaxLevel <= this.rarityWeights.get(i))) continue;
            return SpellRarity.values()[i + lookupOffset];
        }
        return SpellRarity.COMMON;
    }

    public int getMinLevelForRarity(SpellRarity rarity) {
        if (this.rarityWeights == null) {
            this.initializeRarityWeights();
        }
        int minRarity = this.getMinRarity();
        int maxLevel = this.getMaxLevel();
        if (rarity.getValue() < minRarity) {
            return 0;
        }
        if (rarity.getValue() == minRarity) {
            return 1;
        }
        return (int)(this.rarityWeights.get(rarity.getValue() - (1 + minRarity)) * (double)maxLevel) + 1;
    }

    public AbstractSpell getSpellForRarity(SpellRarity rarity) {
        int level = this.getMinLevelForRarity(rarity);
        if (level == 0) {
            return AbstractSpell.getSpell(NONE_SPELL, 0);
        }
        return this.getSpellForType(level);
    }

    private float lerp(float a, float b, float f) {
        return a + f * (b - a);
    }

    public SchoolType getSchoolType() {
        return ServerConfigs.getSpellConfig(this).school();
    }

    public static List<SpellType> getSpellsFromSchool(SchoolType school) {
        return Arrays.stream(SpellType.values()).filter(spellType -> spellType.getSchoolType() == school).toList();
    }

    public static void assignSpellToSchool(SpellType spellType, SchoolType schoolType) {
        List spells = spellsForSchool.getOrDefault((Object)schoolType, new ArrayList());
        spells.add(spellType);
        spellsForSchool.put(schoolType, spells);
    }

    public String getComponentId() {
        return String.format("spell.%s.%s", "irons_spellbooks", this.getId());
    }

    public MutableComponent getDisplayName() {
        return Component.translatable(this.getComponentId(), new Object[0]);
    }

    public ResourceLocation getResourceLocation() {
        return new ResourceLocation("irons_spellbooks", "textures/gui/spell_icons/" + this.getId() + ".png");
    }

    public DamageSource getDamageSource() {
        return new DamageSource(this.getId() + "_spell");
    }

    public DamageSource getDamageSource(Entity attacker) {
        return DamageSources.directDamageSource(this.getDamageSource(), attacker);
    }

    public DamageSource getDamageSource(Entity projectile, Entity attacker) {
        return DamageSources.indirectDamageSource(this.getDamageSource(), projectile, attacker);
    }

    public boolean isEnabled() {
        return ServerConfigs.getSpellConfig(this).enabled();
    }

    public String getId() {
        return this.toString().toLowerCase().replace("_spell", "");
    }

    private boolean quickSearch(SpellType[] array, SpellType query) {
        for (SpellType spellType : array) {
            if (!spellType.equals((Object)query)) continue;
            return true;
        }
        return false;
    }

    static {
        spellsForSchool = new HashMap();
    }

    private static interface GetSpellForType {
        public AbstractSpell get(int var1);
    }
}

