/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells;

import com.google.common.util.concurrent.AtomicDouble;
import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.MutableComponent;
import net.minecraftforge.common.util.LazyOptional;

public enum SpellRarity {
    COMMON(0),
    UNCOMMON(1),
    RARE(2),
    EPIC(3),
    LEGENDARY(4);

    private final int value;
    private static final LazyOptional<List<Double>> rawRarityConfig;
    private static List<Double> rarityConfig;
    private final MutableComponent[] DISPLAYS = new MutableComponent[]{Component.translatable("rarity.irons_spellbooks.common", new Object[0]).m_130940_(ChatFormatting.GRAY), Component.translatable("rarity.irons_spellbooks.uncommon", new Object[0]).m_130940_(ChatFormatting.GREEN), Component.translatable("rarity.irons_spellbooks.rare", new Object[0]).m_130940_(ChatFormatting.AQUA), Component.translatable("rarity.irons_spellbooks.epic", new Object[0]).m_130940_(ChatFormatting.LIGHT_PURPLE), Component.translatable("rarity.irons_spellbooks.legendary", new Object[0]).m_130940_(ChatFormatting.GOLD), Component.translatable("rarity.irons_spellbooks.mythic", new Object[0]).m_130940_(ChatFormatting.GOLD), Component.translatable("rarity.irons_spellbooks.ancient", new Object[0]).m_130940_(ChatFormatting.GOLD)};

    private SpellRarity(int newValue) {
        this.value = newValue;
    }

    public int getValue() {
        return this.value;
    }

    public MutableComponent getDisplayName() {
        return this.DISPLAYS[this.getValue()];
    }

    public static List<Double> getRawRarityConfig() {
        return (List)rawRarityConfig.resolve().get();
    }

    private static List<Double> getRawRarityConfigInternal() {
        List fromConfig = (List)ServerConfigs.RARITY_CONFIG.get();
        if (fromConfig.size() != 5) {
            List configDefault = (List)ServerConfigs.RARITY_CONFIG.get();
            IronsSpellbooks.LOGGER.info("INVALID RARITY CONFIG FOUND (Size != 5): {} FALLING BACK TO DEFAULT: {}", (Object)fromConfig, (Object)configDefault);
            return configDefault;
        }
        if (fromConfig.stream().mapToDouble(a -> a).sum() != 1.0) {
            List configDefault = (List)ServerConfigs.RARITY_CONFIG.get();
            IronsSpellbooks.LOGGER.info("INVALID RARITY CONFIG FOUND (Values must add up to 1): {} FALLING BACK TO DEFAULT: {}", (Object)fromConfig, (Object)configDefault);
            return configDefault;
        }
        return fromConfig;
    }

    public static List<Double> getRarityConfig() {
        if (rarityConfig == null) {
            AtomicDouble counter = new AtomicDouble();
            rarityConfig = new ArrayList<Double>();
            SpellRarity.getRawRarityConfig().forEach(item -> rarityConfig.add(counter.addAndGet(item.doubleValue())));
        }
        return rarityConfig;
    }

    public int compareRarity(SpellRarity other) {
        return Integer.compare(this.getValue(), other.getValue());
    }

    public static void rarityTest() {
        StringBuilder sb = new StringBuilder();
        Arrays.stream(SpellType.values()).forEach(s -> {
            int i;
            sb.append(String.format("\nSpellType:%s\n", s));
            sb.append(String.format("\tMinRarity:%s, MaxRarity:%s\n", s.getMinRarity(), s.getMaxRarity()));
            sb.append(String.format("\tMinLevel:%s, MaxLevel:%s\n", s.getMinLevel(), s.getMaxLevel()));
            sb.append(String.format("\tRawRarityConfig:%s\n", SpellRarity.getRawRarityConfig().stream().map(Object::toString).collect(Collectors.joining(","))));
            sb.append(String.format("\tRarityConfig:%s\n", SpellRarity.getRarityConfig().stream().map(Object::toString).collect(Collectors.joining(","))));
            for (i = s.getMinLevel(); i <= s.getMaxLevel(); ++i) {
                sb.append(String.format("\t\tLevel %s -> %s\n", new Object[]{i, s.getRarity(i)}));
            }
            sb.append("\n");
            for (i = s.getMinRarity(); i <= s.getMaxRarity(); ++i) {
                sb.append(String.format("\t\t%s -> Level %s\n", new Object[]{SpellRarity.values()[i], s.getMinLevelForRarity(SpellRarity.values()[i])}));
            }
        });
    }

    public ChatFormatting getChatFormatting() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case COMMON -> ChatFormatting.GRAY;
            case UNCOMMON -> ChatFormatting.GREEN;
            case RARE -> ChatFormatting.AQUA;
            case EPIC -> ChatFormatting.LIGHT_PURPLE;
            case LEGENDARY -> ChatFormatting.GOLD;
        };
    }

    static {
        rawRarityConfig = LazyOptional.of(SpellRarity::getRawRarityConfigInternal);
        rarityConfig = null;
    }
}

