/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.spells;

import io.redspace.ironsspellbooks.IronsSpellbooks;
import io.redspace.ironsspellbooks.capabilities.magic.CastData;
import io.redspace.ironsspellbooks.capabilities.magic.CastDataSerializable;
import io.redspace.ironsspellbooks.capabilities.magic.MagicManager;
import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import io.redspace.ironsspellbooks.item.Scroll;
import io.redspace.ironsspellbooks.item.SpellBook;
import io.redspace.ironsspellbooks.network.ClientboundSyncMana;
import io.redspace.ironsspellbooks.network.ClientboundUpdateCastingState;
import io.redspace.ironsspellbooks.network.spell.ClientboundOnCastFinished;
import io.redspace.ironsspellbooks.network.spell.ClientboundOnCastStarted;
import io.redspace.ironsspellbooks.network.spell.ClientboundOnClientCast;
import io.redspace.ironsspellbooks.player.ClientInputEvents;
import io.redspace.ironsspellbooks.player.ClientSpellCastHelper;
import io.redspace.ironsspellbooks.registries.AttributeRegistry;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import io.redspace.ironsspellbooks.setup.Messages;
import io.redspace.ironsspellbooks.spells.CastSource;
import io.redspace.ironsspellbooks.spells.CastType;
import io.redspace.ironsspellbooks.spells.SchoolType;
import io.redspace.ironsspellbooks.spells.SpellRarity;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.util.AnimationHolder;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetActionBarTextPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import software.bernie.geckolib3.core.builder.ILoopType;

public abstract class AbstractSpell {
    public static ResourceLocation ANIMATION_RESOURCE = new ResourceLocation("irons_spellbooks", "animation");
    private static final AnimationHolder ANIMATION_INSTANT_CAST = new AnimationHolder("instant_projectile", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    private static final AnimationHolder ANIMATION_CONTINUOUS_CAST = new AnimationHolder("continuous_thrust", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME);
    private static final AnimationHolder ANIMATION_CHARGED_CAST = new AnimationHolder("charged_throw", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    private static final AnimationHolder ANIMATION_LONG_CAST = new AnimationHolder("long_cast", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    private static final AnimationHolder ANIMATION_LONG_CAST_FINISH = new AnimationHolder("long_cast_finish", (ILoopType)ILoopType.EDefaultLoopTypes.PLAY_ONCE);
    public static final AnimationHolder ANIMATION_CONTINUOUS_OVERHEAD = new AnimationHolder("continuous_overhead", (ILoopType)ILoopType.EDefaultLoopTypes.HOLD_ON_LAST_FRAME);
    private final SpellType spellType;
    private final CastType castType;
    protected int level;
    protected int baseManaCost;
    protected int manaCostPerLevel;
    protected int baseSpellPower;
    protected int spellPowerPerLevel;
    protected int castTime;

    public AbstractSpell(SpellType spellType) {
        this.spellType = spellType;
        this.castType = spellType.getCastType();
    }

    public int getID() {
        return this.spellType.getValue();
    }

    public SpellType getSpellType() {
        return this.spellType;
    }

    public SpellRarity getRarity() {
        return this.spellType.getRarity(this.getLevel(null));
    }

    public CastType getCastType() {
        return this.castType;
    }

    public SchoolType getSchoolType() {
        return this.spellType.getSchoolType();
    }

    public int getLevel(@Nullable LivingEntity caster) {
        return this.level;
    }

    public int getRawLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public int getManaCost() {
        return (int)((double)(this.baseManaCost + this.manaCostPerLevel * (this.getLevel(null) - 1)) * ServerConfigs.getSpellConfig(this.spellType).manaMultiplier());
    }

    public int getSpellCooldown() {
        return ServerConfigs.getSpellConfig(this.spellType).cooldownInTicks();
    }

    private int getCastTime() {
        return this.castTime;
    }

    public CastDataSerializable getEmptyCastData() {
        return null;
    }

    public abstract Optional<SoundEvent> getCastStartSound();

    public abstract Optional<SoundEvent> getCastFinishSound();

    public AnimationHolder getCastStartAnimation() {
        return switch (this.castType) {
            case CastType.INSTANT -> ANIMATION_INSTANT_CAST;
            case CastType.CONTINUOUS -> ANIMATION_CONTINUOUS_CAST;
            case CastType.LONG -> ANIMATION_LONG_CAST;
            case CastType.CHARGE -> ANIMATION_CHARGED_CAST;
            default -> AnimationHolder.none();
        };
    }

    public AnimationHolder getCastFinishAnimation() {
        return switch (this.castType) {
            case CastType.LONG -> ANIMATION_LONG_CAST_FINISH;
            default -> AnimationHolder.none();
        };
    }

    public float getSpellPower(@Nullable Entity sourceEntity) {
        float entitySpellPowerModifier = 1.0f;
        float entitySchoolPowerModifier = 1.0f;
        float configPowerModifier = (float)ServerConfigs.getSpellConfig(this.spellType).powerMultiplier();
        int level = this.getLevel(null);
        if (sourceEntity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)sourceEntity;
            level = this.getLevel(livingEntity);
            entitySpellPowerModifier = (float)livingEntity.m_21133_((Attribute)AttributeRegistry.SPELL_POWER.get());
            switch (this.getSchoolType()) {
                case FIRE: {
                    entitySchoolPowerModifier = (float)livingEntity.m_21133_((Attribute)AttributeRegistry.FIRE_SPELL_POWER.get());
                    break;
                }
                case ICE: {
                    entitySchoolPowerModifier = (float)livingEntity.m_21133_((Attribute)AttributeRegistry.ICE_SPELL_POWER.get());
                    break;
                }
                case LIGHTNING: {
                    entitySchoolPowerModifier = (float)livingEntity.m_21133_((Attribute)AttributeRegistry.LIGHTNING_SPELL_POWER.get());
                    break;
                }
                case HOLY: {
                    entitySchoolPowerModifier = (float)livingEntity.m_21133_((Attribute)AttributeRegistry.HOLY_SPELL_POWER.get());
                    break;
                }
                case ENDER: {
                    entitySchoolPowerModifier = (float)livingEntity.m_21133_((Attribute)AttributeRegistry.ENDER_SPELL_POWER.get());
                    break;
                }
                case BLOOD: {
                    entitySchoolPowerModifier = (float)livingEntity.m_21133_((Attribute)AttributeRegistry.BLOOD_SPELL_POWER.get());
                    break;
                }
                case EVOCATION: {
                    entitySchoolPowerModifier = (float)livingEntity.m_21133_((Attribute)AttributeRegistry.EVOCATION_SPELL_POWER.get());
                    break;
                }
                case POISON: {
                    entitySchoolPowerModifier = (float)livingEntity.m_21133_((Attribute)AttributeRegistry.POISON_SPELL_POWER.get());
                }
            }
        }
        return (float)(this.baseSpellPower + this.spellPowerPerLevel * (level - 1)) * entitySpellPowerModifier * entitySchoolPowerModifier * configPowerModifier;
    }

    public int getEffectiveCastTime(@Nullable LivingEntity entity) {
        double entityCastTimeModifier = 1.0;
        if (entity != null) {
            entityCastTimeModifier = this.castType != CastType.CONTINUOUS ? 2.0 - Utils.softCapFormula(entity.m_21133_((Attribute)AttributeRegistry.CAST_TIME_REDUCTION.get())) : entity.m_21133_((Attribute)AttributeRegistry.CAST_TIME_REDUCTION.get());
        }
        return Math.round((float)this.castTime * (float)entityCastTimeModifier);
    }

    public static AbstractSpell getSpell(SpellType spellType, int level) {
        return spellType.getSpellForType(level);
    }

    public static AbstractSpell getSpell(int spellId, int level) {
        return AbstractSpell.getSpell(SpellType.values()[spellId], level);
    }

    public boolean attemptInitiateCast(ItemStack stack, Level level, Player player, CastSource castSource, boolean triggerCooldown) {
        IronsSpellbooks.LOGGER.debug("AbstractSpell.attemptInitiateCast isClient:{}, spell{}({})", new Object[]{level.f_46443_, this.spellType, this.getRawLevel()});
        if (level.f_46443_) {
            return false;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        PlayerMagicData playerMagicData = PlayerMagicData.getPlayerMagicData((LivingEntity)serverPlayer);
        if (!playerMagicData.isCasting()) {
            int playerMana = playerMagicData.getMana();
            boolean hasEnoughMana = playerMana - this.getManaCost() >= 0;
            boolean isSpellOnCooldown = playerMagicData.getPlayerCooldowns().isOnCooldown(this.spellType);
            if ((castSource == CastSource.SPELLBOOK || castSource == CastSource.SWORD) && isSpellOnCooldown) {
                serverPlayer.f_8906_.m_141995_((Packet)new ClientboundSetActionBarTextPacket((Component)io.redspace.ironsspellbooks.util.Component.translatable("ui.irons_spellbooks.cast_error_cooldown", this.spellType.getDisplayName()).m_130940_(ChatFormatting.RED)));
                return false;
            }
            if (castSource.consumesMana() && !hasEnoughMana) {
                serverPlayer.f_8906_.m_141995_((Packet)new ClientboundSetActionBarTextPacket((Component)io.redspace.ironsspellbooks.util.Component.translatable("ui.irons_spellbooks.cast_error_mana", this.spellType.getDisplayName()).m_130940_(ChatFormatting.RED)));
                return false;
            }
            if (!this.checkPreCastConditions(level, (LivingEntity)serverPlayer, playerMagicData)) {
                return false;
            }
            if (this.castType == CastType.INSTANT) {
                this.castSpell(level, serverPlayer, castSource, triggerCooldown);
            } else if (this.castType == CastType.LONG || this.castType == CastType.CONTINUOUS || this.castType == CastType.CHARGE) {
                int effectiveCastTime = this.getEffectiveCastTime((LivingEntity)player);
                playerMagicData.initiateCast(this.getID(), this.getLevel((LivingEntity)player), effectiveCastTime, castSource);
                this.onServerPreCast(player.f_19853_, (LivingEntity)player, playerMagicData);
                Messages.sendToPlayer(new ClientboundUpdateCastingState(this.getID(), this.getLevel((LivingEntity)player), effectiveCastTime, castSource), serverPlayer);
            }
            Messages.sendToPlayersTrackingEntity(new ClientboundOnCastStarted(serverPlayer.m_142081_(), this.spellType), (Entity)serverPlayer, true);
            return true;
        }
        Utils.serverSideCancelCast(serverPlayer);
        return false;
    }

    public void castSpell(Level world, ServerPlayer serverPlayer, CastSource castSource, boolean triggerCooldown) {
        IronsSpellbooks.LOGGER.debug("AbstractSpell.castSpell isClient:{}, spell{}({})", new Object[]{world.f_46443_, this.spellType, this.getRawLevel()});
        MagicManager magicManager = MagicManager.get(serverPlayer.f_19853_);
        PlayerMagicData playerMagicData = PlayerMagicData.getPlayerMagicData((LivingEntity)serverPlayer);
        if (castSource.consumesMana()) {
            int newMana = playerMagicData.getMana() - this.getManaCost();
            magicManager.setPlayerCurrentMana(serverPlayer, newMana);
            Messages.sendToPlayer(new ClientboundSyncMana(playerMagicData), serverPlayer);
        }
        if (triggerCooldown) {
            MagicManager.get(serverPlayer.f_19853_).addCooldown(serverPlayer, this.spellType, castSource);
        }
        this.onCast(world, (LivingEntity)serverPlayer, playerMagicData);
        Messages.sendToPlayer(new ClientboundOnClientCast(this.getID(), this.getLevel((LivingEntity)serverPlayer), castSource, playerMagicData.getAdditionalCastData()), serverPlayer);
        if (this.castType == CastType.INSTANT) {
            this.onServerCastComplete(world, (LivingEntity)serverPlayer, playerMagicData, false);
        }
        if (serverPlayer.m_21205_().m_41720_() instanceof SpellBook || serverPlayer.m_21205_().m_41720_() instanceof Scroll) {
            playerMagicData.setPlayerCastingItem(serverPlayer.m_21205_());
        } else {
            playerMagicData.setPlayerCastingItem(serverPlayer.m_21206_());
        }
    }

    public void onClientCast(Level level, LivingEntity entity, CastData castData) {
        IronsSpellbooks.LOGGER.debug("AbstractSpell.onClientCast isClient:{}, spell{}({})", new Object[]{level.f_46443_, this.spellType, this.getRawLevel()});
        this.playSound(this.getCastFinishSound(), (Entity)entity, true);
        if (ClientInputEvents.isUseKeyDown) {
            if (this.spellType.getCastType().holdToCast()) {
                ClientSpellCastHelper.setSuppressRightClicks(true);
            }
            ClientInputEvents.hasReleasedSinceCasting = false;
        }
    }

    public void onCast(Level level, LivingEntity entity, PlayerMagicData playerMagicData) {
        IronsSpellbooks.LOGGER.debug("AbstractSpell.onCast isClient:{}, spell{}({}), pmd:{}", new Object[]{level.f_46443_, this.spellType, this.getRawLevel(), playerMagicData});
        this.playSound(this.getCastFinishSound(), (Entity)entity, true);
    }

    protected void playSound(Optional<SoundEvent> sound, Entity entity, boolean playDefaultSound) {
        if (sound.isPresent()) {
            entity.m_5496_(sound.get(), 2.0f, 1.0f);
        } else if (playDefaultSound) {
            entity.m_5496_(this.defaultCastSound(), 2.0f, 1.0f);
        }
    }

    public boolean checkPreCastConditions(Level level, LivingEntity entity, PlayerMagicData playerMagicData) {
        return true;
    }

    protected void playSound(Optional<SoundEvent> sound, Entity entity) {
        this.playSound(sound, entity, false);
    }

    private SoundEvent defaultCastSound() {
        return switch (this.getSchoolType()) {
            case SchoolType.FIRE -> (SoundEvent)SoundRegistry.FIRE_CAST.get();
            case SchoolType.ICE -> (SoundEvent)SoundRegistry.ICE_CAST.get();
            case SchoolType.LIGHTNING -> (SoundEvent)SoundRegistry.LIGHTNING_CAST.get();
            case SchoolType.HOLY -> (SoundEvent)SoundRegistry.HOLY_CAST.get();
            case SchoolType.ENDER -> (SoundEvent)SoundRegistry.ENDER_CAST.get();
            case SchoolType.BLOOD -> (SoundEvent)SoundRegistry.BLOOD_CAST.get();
            case SchoolType.EVOCATION -> (SoundEvent)SoundRegistry.EVOCATION_CAST.get();
            case SchoolType.POISON -> (SoundEvent)SoundRegistry.POISON_CAST.get();
            default -> (SoundEvent)SoundRegistry.EVOCATION_CAST.get();
        };
    }

    public void onServerCastComplete(Level level, LivingEntity entity, PlayerMagicData playerMagicData, boolean cancelled) {
        IronsSpellbooks.LOGGER.debug("AbstractSpell.onServerCastComplete isClient:{}, spell{}({}), pmd:{}, cancelled:{}", new Object[]{level.f_46443_, this.spellType, this.getRawLevel(), playerMagicData, cancelled});
        playerMagicData.resetCastingState();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            Messages.sendToPlayersTrackingEntity(new ClientboundOnCastFinished(serverPlayer.m_142081_(), this.spellType, cancelled), (Entity)serverPlayer, true);
        }
    }

    public void onClientPreCast(Level level, LivingEntity entity, InteractionHand hand, @Nullable PlayerMagicData playerMagicData) {
        IronsSpellbooks.LOGGER.debug("AbstractSpell.onClientPreCast isClient:{}, spell{}({}), pmd:{}", new Object[]{level.f_46443_, this.spellType, this.getRawLevel(), playerMagicData});
        this.playSound(this.getCastStartSound(), (Entity)entity);
    }

    public void onServerPreCast(Level level, LivingEntity entity, @Nullable PlayerMagicData playerMagicData) {
        IronsSpellbooks.LOGGER.debug("AbstractSpell.onServerPreCast isClient:{}, spell{}({}), pmd:{}", new Object[]{level.f_46443_, this.spellType, this.getRawLevel(), playerMagicData});
        this.playSound(this.getCastStartSound(), (Entity)entity);
    }

    public void onServerCastTick(Level level, LivingEntity entity, @Nullable PlayerMagicData playerMagicData) {
    }

    public boolean shouldAIStopCasting(AbstractSpellCastingMob mob, LivingEntity target) {
        return false;
    }

    public List<MutableComponent> getUniqueInfo(LivingEntity caster) {
        return List.of();
    }

    public boolean equals(Object obj) {
        AbstractSpell o = (AbstractSpell)obj;
        if (o == null) {
            return false;
        }
        return this.spellType == o.spellType && this.level == o.level;
    }
}

