/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.player;

import io.redspace.ironsspellbooks.capabilities.magic.PlayerMagicData;
import io.redspace.ironsspellbooks.capabilities.spell.SpellData;
import io.redspace.ironsspellbooks.config.ServerConfigs;
import io.redspace.ironsspellbooks.effect.AbyssalShroudEffect;
import io.redspace.ironsspellbooks.effect.EvasionEffect;
import io.redspace.ironsspellbooks.effect.SummonTimer;
import io.redspace.ironsspellbooks.entity.mobs.abstract_spell_casting_mob.AbstractSpellCastingMob;
import io.redspace.ironsspellbooks.entity.spells.root.PreventDismount;
import io.redspace.ironsspellbooks.item.SpellBook;
import io.redspace.ironsspellbooks.item.armor.UpgradeType;
import io.redspace.ironsspellbooks.item.curios.CurioBaseItem;
import io.redspace.ironsspellbooks.registries.AttributeRegistry;
import io.redspace.ironsspellbooks.registries.ItemRegistry;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import io.redspace.ironsspellbooks.spells.CastType;
import io.redspace.ironsspellbooks.spells.SpellType;
import io.redspace.ironsspellbooks.tetra.TetraProxy;
import io.redspace.ironsspellbooks.util.UpgradeUtils;
import io.redspace.ironsspellbooks.util.Utils;
import java.util.Map;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.ItemAttributeModifierEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import top.theillusivec4.curios.api.CuriosApi;

@Mod.EventBusSubscriber
public class ServerPlayerEvents {
    @SubscribeEvent
    public static void onLivingEquipmentChangeEvent(LivingEquipmentChangeEvent event) {
        ServerPlayer serverPlayer;
        PlayerMagicData playerMagicData;
        if (event.getEntity().f_19853_.f_46443_) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer && (playerMagicData = PlayerMagicData.getPlayerMagicData((LivingEntity)(serverPlayer = (ServerPlayer)entity))).isCasting() && (event.getSlot().m_20749_() == 0 || event.getSlot().m_20749_() == 1) && (event.getFrom().m_41720_() instanceof SpellBook || SpellData.hasSpellData(event.getFrom()))) {
            Utils.serverSideCancelCast(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void onPlayerOpenContainer(PlayerContainerEvent.Open event) {
        ServerPlayer serverPlayer;
        PlayerMagicData playerMagicData;
        if (event.getEntity().f_19853_.f_46443_) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer && (playerMagicData = PlayerMagicData.getPlayerMagicData((LivingEntity)(serverPlayer = (ServerPlayer)entity))).isCasting()) {
            Utils.serverSideCancelCast(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void handleUpgradeModifiers(ItemAttributeModifierEvent event) {
        ItemStack itemStack = event.getItemStack();
        if (!UpgradeUtils.isUpgraded(itemStack)) {
            return;
        }
        EquipmentSlot slot = event.getSlotType();
        if (UpgradeUtils.getUpgradedSlot(itemStack) != slot) {
            return;
        }
        Map<UpgradeType, Integer> upgrades = UpgradeUtils.deserializeUpgrade(itemStack);
        for (Map.Entry<UpgradeType, Integer> entry : upgrades.entrySet()) {
            UpgradeType upgradeType = entry.getKey();
            int count = entry.getValue();
            double baseAmount = UpgradeUtils.collectAndRemovePreexistingAttribute(event, (Attribute)upgradeType.attribute.get(), upgradeType.operation);
            event.addModifier((Attribute)upgradeType.attribute.get(), new AttributeModifier(UpgradeUtils.UUIDForSlot(slot), "upgrade", baseAmount + (double)(upgradeType.amountPerUpgrade * (float)count), entry.getKey().operation));
        }
    }

    @SubscribeEvent
    public static void onExperienceDroppedEvent(LivingExperienceDropEvent event) {
        Player player = event.getAttackingPlayer();
        if (player != null) {
            int ringCount = CuriosApi.getCuriosHelper().findCurios((LivingEntity)player, (Item)ItemRegistry.EMERALD_STONEPLATE_RING.get()).size();
            for (int i = 0; i < ringCount; ++i) {
                event.setDroppedExperience((int)((double)event.getDroppedExperience() * 1.25));
            }
        }
    }

    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            entity = event.getTarget();
            if (entity instanceof ServerPlayer) {
                ServerPlayer targetPlayer = (ServerPlayer)entity;
                PlayerMagicData.getPlayerMagicData((LivingEntity)serverPlayer).getSyncedData().syncToPlayer(targetPlayer);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            PlayerMagicData playerMagicData = PlayerMagicData.getPlayerMagicData((LivingEntity)serverPlayer);
            playerMagicData.getPlayerCooldowns().syncToPlayer(serverPlayer);
            playerMagicData.getSyncedData().syncToPlayer(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            event.getEntity().m_20095_();
            event.getEntity().m_146917_(0);
            Entity entity = event.getEntity();
            if (entity instanceof ServerPlayer) {
                ServerPlayer newServerPlayer = (ServerPlayer)entity;
                event.getOriginal().m_21220_().forEach(effect -> {
                    if (effect.m_19544_() instanceof SummonTimer) {
                        newServerPlayer.m_147207_(effect, (Entity)newServerPlayer);
                    }
                });
            }
        }
    }

    @SubscribeEvent
    public static void onLivingDeathEvent(LivingDeathEvent event) {
        event.getEntity().m_20095_();
        event.getEntity().m_146917_(0);
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            Utils.serverSideCancelCast(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            Utils.serverSideCancelCast(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        event.getEntity().m_20095_();
        event.getEntity().m_146917_(0);
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            Utils.serverSideCancelCast(serverPlayer);
            serverPlayer.m_21220_().forEach(effect -> {
                if (effect.m_19544_() instanceof SummonTimer) {
                    serverPlayer.f_8906_.m_141995_((Packet)new ClientboundUpdateMobEffectPacket(serverPlayer.m_142049_(), effect));
                }
            });
            PlayerMagicData.getPlayerMagicData((LivingEntity)serverPlayer).setMana((int)(serverPlayer.m_21133_((Attribute)AttributeRegistry.MAX_MANA.get()) * (Double)ServerConfigs.MANA_SPAWN_PERCENT.get()));
        }
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof ServerPlayer || livingEntity instanceof AbstractSpellCastingMob) {
            PlayerMagicData playerMagicData = PlayerMagicData.getPlayerMagicData(livingEntity);
            if (playerMagicData.getSyncedData().hasEffect(2L)) {
                if (EvasionEffect.doEffect(livingEntity, event.getSource())) {
                    event.setCanceled(true);
                }
            } else if (playerMagicData.getSyncedData().hasEffect(8L) && AbyssalShroudEffect.doEffect(livingEntity, event.getSource())) {
                event.setCanceled(true);
            }
        }
        TetraProxy.PROXY.handleLivingAttackEvent(event);
    }

    @SubscribeEvent
    public static void onLivingTakeDamage(LivingDamageEvent event) {
        PlayerMagicData playerMagicData;
        LivingEntity livingAttacker;
        Entity attacker = event.getSource().m_7639_();
        if (attacker instanceof LivingEntity && (livingAttacker = (LivingEntity)attacker).m_21023_((MobEffect)MobEffectRegistry.SPIDER_ASPECT.get()) && event.getEntityLiving().m_21023_(MobEffects.f_19614_)) {
            int lvl = livingAttacker.m_21124_((MobEffect)MobEffectRegistry.SPIDER_ASPECT.get()).m_19564_() + 1;
            float before = event.getAmount();
            float multiplier = 1.0f + 0.05f * (float)lvl;
            event.setAmount(event.getAmount() * multiplier);
        }
        if ((playerMagicData = PlayerMagicData.getPlayerMagicData(event.getEntityLiving())).getSyncedData().hasEffect(4L)) {
            playerMagicData.getSyncedData().addHeartstopDamage(event.getAmount() * 0.5f);
            event.setCanceled(true);
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            if (playerMagicData.isCasting() && SpellType.values()[playerMagicData.getCastingSpellId()].getCastType() == CastType.LONG && !((CurioBaseItem)((Object)ItemRegistry.CONCENTRATION_AMULET.get())).isEquippedBy((LivingEntity)serverPlayer) && event.getSource() != DamageSource.f_146701_ && event.getSource() != DamageSource.f_19313_ && event.getSource() != DamageSource.f_19307_ && event.getSource() != DamageSource.f_19320_) {
                Utils.serverSideCancelCast(serverPlayer);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityMountEvent(EntityMountEvent event) {
        ServerPlayer serverPlayer;
        PlayerMagicData playerMagicData;
        if (event.getEntity().f_19853_.f_46443_) {
            return;
        }
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer && (playerMagicData = PlayerMagicData.getPlayerMagicData((LivingEntity)(serverPlayer = (ServerPlayer)entity))).isCasting()) {
            Utils.serverSideCancelCast(serverPlayer);
        }
    }

    @SubscribeEvent
    public static void preventDismount(EntityMountEvent event) {
        if (!event.getEntity().f_19853_.f_46443_ && event.getEntityBeingMounted() instanceof PreventDismount && event.isDismounting() && !event.getEntityBeingMounted().m_146910_()) {
            event.setCanceled(true);
        }
    }
}

