/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.player;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.KeyMapping;
import net.minecraftforge.client.ClientRegistry;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;

public final class KeyMappings {
    public static final String KEY_BIND_GENERAL_CATEGORY = "key.irons_spellbooks.group_1";
    public static final String KEY_BIND_QUICK_CAST_CATEGORY = "key.irons_spellbooks.group_2";
    public static final KeyMapping SPELL_WHEEL_KEYMAP = new KeyMapping(KeyMappings.getResourceName("spell_wheel"), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 82, "key.irons_spellbooks.group_1");
    public static final KeyMapping SPELLBAR_SCROLL_MODIFIER_KEYMAP = new KeyMapping(KeyMappings.getResourceName("spell_bar_modifier"), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 340, "key.irons_spellbooks.group_1");
    public static final List<KeyMapping> QUICK_CAST_MAPPINGS = KeyMappings.createQuickCastKeybinds();

    private static String getResourceName(String name) {
        return String.format("key.irons_spellbooks.%s", name);
    }

    public static void onRegisterKeybinds() {
        ClientRegistry.registerKeyBinding((KeyMapping)SPELL_WHEEL_KEYMAP);
        ClientRegistry.registerKeyBinding((KeyMapping)SPELLBAR_SCROLL_MODIFIER_KEYMAP);
        QUICK_CAST_MAPPINGS.forEach(ClientRegistry::registerKeyBinding);
    }

    private static List<KeyMapping> createQuickCastKeybinds() {
        ArrayList<KeyMapping> qcm = new ArrayList<KeyMapping>();
        for (int i = 1; i <= 15; ++i) {
            qcm.add(new KeyMapping(KeyMappings.getResourceName(String.format("spell_quick_cast_%d", i)), (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, InputConstants.f_84822_.m_84873_(), KEY_BIND_QUICK_CAST_CATEGORY));
        }
        return qcm;
    }
}

